<?php

namespace Drop\BetterNewsletter\Model;

use Drop\BetterNewsletter\Api\Data\NewsletterSubscriptionInterface;
use Drop\BetterNewsletter\Api\NewsletterSubscriptionManagementInterface;
use Drop\BetterNewsletter\Model\Data\NewsletterSubscription;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\QuoteIdMaskFactory;
use \Drop\BetterNewsletter\Logger\Logger;

class NewsletterSubscriptionManagement implements NewsletterSubscriptionManagementInterface
{
    /**
     * @var CartRepositoryInterface
     */
    private $cartRepository;
    /**
     * @var QuoteIdMaskFactory
     */
    private $quoteIdMaskFactory;
    /**
     * @var Logger
     */
    private $logger;
    
    public function __construct(
        CartRepositoryInterface $cartRepository,
        QuoteIdMaskFactory $quoteIdMaskFactory,
        Logger $logger
    ) {
        $this->cartRepository = $cartRepository;
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->logger = $logger;
    }
    /**
     * @param string $cartId
     * @param NewsletterSubscriptionInterface $newsletterSubscription
     * @throws CouldNotSaveException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @return void
     */
    public function subscribe($cartId, NewsletterSubscriptionInterface $newsletterSubscription)
    {
        if ((bool)$newsletterSubscription->getSubscribe()) {
            $quote = $this->getQuoteByCardId($cartId);
            try {
                $quote->setData(NewsletterSubscription::NEWSLETTER_SUBSCRIPTION, 1);
                $this->cartRepository->save($quote);
            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
                return false;
            }
        }
    }
    /**
     * @param $cartId
     * @return \Magento\Quote\Api\Data\CartInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    private function getQuoteByCardId($cartId)
    {
        try {
            return $this->cartRepository->getActive($cartId);
        } catch (\Exception $e) {
            $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
            return $this->cartRepository->getActive($quoteIdMask->getQuoteId());
        }
    }
}
