<?php

namespace Drop\BetterNewsletter\Model;

class NewActionPlugin extends \Magento\Newsletter\Controller\Subscriber\NewAction
{

    public function execute()
    {
        if ($this->getRequest()->isPost() && $this->getRequest()->getPost('email')) {
            $email = (string)$this->getRequest()->getPost('email');

            try {
                $this->validateEmailFormat($email);
                $this->validateGuestSubscription();
                /*
                * Permit customer that already have an account to subscribe from newsletter form
                * Eventually additional data will be added also in the account
                */
//                $this->validateEmailAvailable($email);

                $subscriber = $this->_subscriberFactory->create()->loadByEmail($email);
                if ($subscriber->getId()
                    && $subscriber->getSubscriberStatus() == \Magento\Newsletter\Model\Subscriber::STATUS_SUBSCRIBED
                ) {
                    // This exception will be logged but is unuseful. Replaced with error message
//                    throw new \Magento\Framework\Exception\LocalizedException(
//                        __('This email address is already subscribed.')
//                    );
                    $this->messageManager->addErrorMessage(__('This email address is already subscribed.'));
                    if($this->getRequest()->isXmlHttpRequest()) {
                        $this->getResponse()->setBody(__('This email address is already subscribed.'));
                    }
                } else {
                    $status = $this->_subscriberFactory->create()->subscribe($email);
                    if ($status == \Magento\Newsletter\Model\Subscriber::STATUS_NOT_ACTIVE) {
                        $this->messageManager->addSuccess(__('The confirmation request has been sent.'));
                        if($this->getRequest()->isXmlHttpRequest()) {
                            $this->getResponse()->setBody(__('The confirmation request has been sent.'));
                        }
                    } else {
                        $this->messageManager->addSuccess(__('Thank you for your subscription.'));
                        if($this->getRequest()->isXmlHttpRequest()) {
                            $this->getResponse()->setBody(__('Thank you for your subscription.'));
                        }
                    }
                }
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addErrorMessage(
                    $e,
                    __('There was a problem with the subscription: %1', $e->getMessage())
                );
                if($this->getRequest()->isXmlHttpRequest()) {
                    $this->getResponse()->setBody(__('There was a problem with the subscription: %1', $e->getMessage()));
                }
            } catch (\Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong with the subscription.'));
                if($this->getRequest()->isXmlHttpRequest()) {
                    $this->getResponse()->setBody($e);
                    //$this->getResponse()->setBody(__('Something went wrong with the subscription.'));
                }
            }
        }
        //se è una chiamata ajax non serve che faccia il redirect
        if(!$this->getRequest()->isXmlHttpRequest()) {
            $this->getResponse()->setRedirect($this->_redirect->getRedirectUrl());
        }
    }

}
