<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Drop\BetterNewsletter\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use \Drop\BetterNewsletter\Helper\Data;

class Index extends Action
{

    /**
     * @var \Drop\BetterNewsletter\Helper\Data
     */
    public $helperData;

    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    public $resultPageFactory;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Data $helperData
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Data $helperData
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->helperData = $helperData;
    }
    
    /**
     * Load the page defined in view/frontend/layout/newsletter_index_index.xml
     *
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        $pageTitle = $this->helperData->getNewsletterPageMetaTitle();
        $resultPage->getConfig()->getTitle()->set(__($pageTitle));
        $resultPage->getConfig()->setDescription(__($this->helperData->getNewsletterPageMetaDescription()));
        $resultPage->getConfig()->setKeywords(__($this->helperData->getNewsletterPageMetaKeywords()));
        if ($this->helperData->getNewsletterPageBreadcrumb()) {
            /** @var \Magento\Theme\Block\Html\Breadcrumbs $breadcrumbsBlock */
            $breadcrumbsBlock = $resultPage->getLayout()->getBlock('breadcrumbs');
            if ($breadcrumbsBlock) {
                $breadcrumbsBlock->addCrumb('home',['label' => __('Home'), 'link' => $this->_url->getUrl('')]);
                $breadcrumbsBlock->addCrumb('newsletter',['label' => __($pageTitle),]);
            }
        }
        
        return $resultPage;
    }

}
