<?php

namespace Drop\BetterNewsletter\Block\Newsletter;

use \Magento\Framework\View\Element\Template\Context;

class Unsubscribe extends \Magento\Framework\View\Element\Template
{

    /**
     * @var \Drop\BetterNewsletter\Helper\Data
     */
    protected $helperData;

    /**
     * Constructor
     *
     * @param Context $context
     * @param \Drop\BetterNewsletter\Helper\Data $helperData
     * @param array $data
     */
    public function __construct(
        Context $context,
        \Drop\BetterNewsletter\Helper\Data $helperData,
        array $data = []
    ) {
        $this->helperData = $helperData;

        parent::__construct($context, $data);
    }

    /**
     * Custom list name
     * @return string
     */
    public function getNewsletterListName() {
        return $this->helperData->getListName();
    }

    /**
     * Default Magento newsletter unsubscription controller url
     * @return string
     */
    public function getFormActionUrl() {
        return $this->getUrl('newsletter/subscriber/unsubscribe', ['_secure' => true]);
    }

}
