<?php
/**
 * Config
 *
 * @copyright Copyright © 2020 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Bettercatalogimageresize\Plugin\Image\Adapter;

use \Magento\Framework\Image\Adapter\Config as ImageAdapterConfig;

class Config extends ImageAdapterConfig
{

    const XML_PATH_MAX_WEIGHT = 'system/upload_configuration/max_weight';
    const XML_PATH_ALLOW_FLY_RESIZE = 'system/upload_configuration/allow_fly_resize';

    /**
     * Get Maximum Image weight
     *
     * @return int
     */
    public function getMaxWeight()
    {
        return $this->config->getValue(self::XML_PATH_MAX_WEIGHT);
    }

    /**
     * Get Maximum Image weight
     *
     * @return int
     */
    public function getAllowFlyResize()
    {
        return (bool) $this->config->isSetFlag(self::XML_PATH_ALLOW_FLY_RESIZE);
    }

}
