<?php
/**
 * AdapterPlugin
 *
 * @copyright Copyright © 2020 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Bettercatalogimageresize\Plugin\Image\Adapter;


use Magento\Framework\App\Filesystem\DirectoryList;

class AdapterPlugin
{
    /**
     * @var \Drop\Bettercatalogimageresize\Plugin\Image\Adapter\Config
     */
    private $config;
    /**
     * @var \Magento\Framework\Convert\DataSize
     */
    private $dataSize;
    /**
     * @var \Magento\Framework\Filesystem
     */
    private $filesystem;
    /**
     * @var \Magento\Framework\Filesystem\Directory\ReadFactory
     */
    private $readFactory;

    /**
     * AdapterPlugin constructor.
     * @param \Drop\Bettercatalogimageresize\Plugin\Image\Adapter\Config $config
     * @param \Magento\Framework\Convert\DataSize $dataSize
     * @param \Magento\Framework\Filesystem\Directory\ReadFactory $readFactory
     */
    public function __construct(
        \Drop\Bettercatalogimageresize\Plugin\Image\Adapter\Config $config,
        \Magento\Framework\Convert\DataSize $dataSize,
        \Magento\Framework\Filesystem\Directory\ReadFactory $readFactory
    )
    {
        $this->config = $config;
        $this->dataSize = $dataSize;
        $this->readFactory = $readFactory;
    }

    /**
     * Check - is this file bigger than maximum
     *
     * @param \Magento\Framework\Image\Adapter\AbstractAdapter $subject
     * @param $result
     * @param string $filePath
     * @return bool
     */
    public function afterValidateUploadFile(\Magento\Framework\Image\Adapter\AbstractAdapter $subject, $result, $filePath)
    {
        if(!$result) {
            return $result;
        }

        $maxWeight = $this->config->getMaxWeight();
        if(empty($maxWeight) || ($maxWeight <= 0)) {
            return $result;
        }

        $maxWeight = $this->dataSize->convertSizeToBytes($maxWeight . 'K');
        return $this->validateMaxSize($filePath, $maxWeight);
    }

    public function validateMaxSize($fileAbsolutePath, $maxWeight)
    {
        $directoryRead = $this->readFactory->create(dirname($fileAbsolutePath));
        $filePath = $directoryRead->getRelativePath($fileAbsolutePath);
        if ($maxWeight > 0 && $directoryRead->stat($filePath)['size'] > $maxWeight
        ) {
            throw new \InvalidArgumentException(
                __('The file you\'re uploading exceeds the server size limit of %1 kilobytes.', $maxWeight)
            );
        }

        return true;
    }

}
