<?php

namespace Drop\BannerInList\Setup;

use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Eav\Model\Entity\Attribute\SetFactory as AttributeSetFactory;

class InstallData implements InstallDataInterface
{
    private $eavSetupFactory;
    private $attributeSetFactory;
    private $attributeSet;
    private $categorySetupFactory;

    const ATTRIBUTE_SET_NAME = 'BannerInList';
    const GROUP_NAME = 'Banner';

    public function __construct(EavSetupFactory $eavSetupFactory, AttributeSetFactory $attributeSetFactory, CategorySetupFactory $categorySetupFactory)
    {
        $this->eavSetupFactory = $eavSetupFactory;
        $this->attributeSetFactory = $attributeSetFactory;
        $this->categorySetupFactory = $categorySetupFactory;
    }

    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $categorySetup = $this->categorySetupFactory->create(['setup' => $setup]);

        $attributeSet = $this->attributeSetFactory->create();
        $entityTypeId = $categorySetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
        $attributeSetId = $categorySetup->getDefaultAttributeSetId($entityTypeId);
        $data = [
            'attribute_set_name' => self::ATTRIBUTE_SET_NAME,
            'entity_type_id'     => $entityTypeId,
            'sort_order'         => 200,
        ];
        $attributeSet->setData($data);
        $attributeSet->validate();
        $attributeSet->save();
        $attributeSet->initFromSkeleton($attributeSetId);
        $attributeSet->save();

        // CREATE PRODUCT ATTRIBUTES
        $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);

        $attributeSetId = $eavSetup->getAttributeSetId($entityTypeId, self::ATTRIBUTE_SET_NAME);

        // REMOVE UNUSED ATTRIBUTE GROUP
        $groupToRemove = ['RMA', 'Design', 'Schedule Design Update', 'Autosettings'];
        foreach ($groupToRemove as $group):
            $group_id = $eavSetup->getAttributeGroupId($entityTypeId, $attributeSetId, $group);
            $eavSetup->removeAttributeGroup($entityTypeId, $attributeSetId, $group_id);
        endforeach;

        // CREATE ATTRIBUTE GROUP
        $eavSetup->addAttributeGroup($entityTypeId, $attributeSetId, self::GROUP_NAME, 1);
        $attributeGroupId = $eavSetup->getAttributeGroupId($entityTypeId, $attributeSetId, self::GROUP_NAME);


        $attributes = [
            [
                "code"  => "messaggio_banner",
                "label" => "Messaggio Banner"
            ],
            [
                "code"  => "call_to_action_banner",
                "label" => "CTA"
            ],
            [
                "code" => "id_prodotto_banner",
                "label" => "ID Prodotto Link"
            ],
            [
                "code"  => "id_categoria_banner",
                "label" => "ID Cat Link"
            ],
            [
                "code"  => "cms_url_key_banner",
                "label" => "Cms Page Url Key"
            ]
        ];
        $sort = 100;
        foreach ($attributes as $attribute) {

            $eavSetup->addAttribute(
                \Magento\Catalog\Model\Product::ENTITY,
                $attribute['code'],
                [
                    'type'                    => 'varchar',
                    'label'                   => $attribute['label'],
                    'backend'                 => '',
                    'input'                   => 'text',
                    'wysiwyg_enabled'         => false,
                    'source'                  => '',
                    'required'                => false,
                    'sort_order'              => $sort++,
                    'global'                  => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_STORE,
                    'searchable'              => false,
                    'filterable'              => false,
                    'comparable'              => false,
                    'used_in_product_listing' => true,
                    'visible_on_front'        => false,
                    'apply_to'                => ''
                ]
            );

            // ADD EXISTING ATTRIBUTE TO GROUP IN ATTRIBUTE SET
            $attributeId = $eavSetup->getAttributeId($entityTypeId, $attribute['code']);
            $eavSetup->addAttributeToGroup($entityTypeId, $attributeSetId, $attributeGroupId, $attributeId, null);
        }

        //RIMUOVE GLI ATTRIBUTI NON NECESSARI
        /*
        'barcode'
        'sku_type'
        'bss_sizechart'
        'ts_dimensions_length'
        'ts_dimensions_width'
        'ts_dimensions_height'
        'weight_type'
        'news_from_date'
        'news_to_date'
        'country_of_manufacture'


        'small_image'
        'thumbnail'
        'swatch_image'
        'gallery'

        'url_key'
        'meta_title'
        'meta_keyword'
        'meta_description'

        'page_layout'
        'options_container'
        'custom_layout_update'
        'custom_design_from'
        'custom_design_to'
        'custom_design'
        'custom_layout'
        'rma_allowed' */


        $setup->endSetup();
    }
}