/*global define*/
define(
    ['jquery', 'uiComponent', 'ko', 'Magento_Customer/js/model/customer', 'Magento_Checkout/js/model/quote', 'Magento_Checkout/js/action/select-shipping-address', 'Magento_Checkout/js/model/shipping-rate-processor/new-address', 'Magento_Checkout/js/action/set-shipping-information', 'Amazon_Payment/js/model/storage', 'Magento_Checkout/js/model/shipping-service', 'Magento_Checkout/js/model/address-converter', 'mage/storage', 'Magento_Checkout/js/model/full-screen-loader', 'Magento_Checkout/js/model/error-processor', 'Magento_Checkout/js/model/url-builder', 'Magento_Checkout/js/checkout-data', 'Magento_Checkout/js/model/checkout-data-resolver', 'uiRegistry', 'Magento_Checkout/js/model/step-navigator', 'mage/translate'],
    function($, Component, ko, customer, quote, selectShippingAddress, shippingProcessor, setShippingInformationAction, amazonStorage, shippingService, addressConverter, storage, fullScreenLoader, errorProcessor, urlBuilder, checkoutData, checkoutDataResolver, registry, stepNavigator) {
        'use strict';
        var self;
        return Component.extend({
            defaults: {
                template: 'Amazon_Payment/checkout-widget-address'
            },
            options: {
                sellerId: registry.get('amazonPayment').merchantId,
                addressWidgetDOMId: 'addressBookWidgetDiv',
                widgetScope: registry.get('amazonPayment').loginScope
            },
            isCustomerLoggedIn: customer.isLoggedIn,
            isAmazonAccountLoggedIn: amazonStorage.isAmazonAccountLoggedIn,
            isAmazonEnabled: ko.observable(registry.get('amazonPayment').isPwaEnabled),
            rates: shippingService.getShippingRates(),
            /**
             * Init
             */
            initialize: function() {
                self = this;
                this._super();
            },
            /**
             * Call when component template is rendered
             */
            initAddressWidget: function() {
                self.renderAddressWidget();
            },
            /**
             * render Amazon address Widget
             */
            renderAddressWidget: function() {
                new OffAmazonPayments.Widgets.AddressBook({ // eslint-disable-line no-undef
                    sellerId: self.options.sellerId,
                    scope: self.options.widgetScope,
                    /**
                     * Order reference creation callback
                     */
                    onOrderReferenceCreate: function(orderReference) {
                        var orderid = orderReference.getAmazonOrderReferenceId();
                        amazonStorage.setOrderReference(orderid);
                    },
                    /**
                     * Address select callback
                     */
                    onAddressSelect: function() { // orderReference
                        $('.modals-wrapper').hide();
                        self.getShippingAddressFromAmazon(function(addressData, tableRates) {
                            self.logicShowHideRegionField(addressData, tableRates)
                        });
                    },
                    design: {
                        designMode: 'responsive'
                    },
                    /**
                     * Error callback
                     */
                    onError: function(error) {
                        console.log(error);
                    }
                }).bind(self.options.addressWidgetDOMId);
            },
            logicShowHideRegionField: function(addressData, tableRates) {
                storage.post('dropamazonpay/index/amazon', JSON.stringify({
                    address: addressData,
                    rates: tableRates().length
                })).done(function(r) {
                    if ((r.error == true && r.shipping_rates == false) || r.error == false) {
                        //Fix asych behavior. (really shipping_rates == false)
                        setTimeout(function() {
                            if (!$('#checkout-step-shipping_method .no-quotes-block').length) {
                                //table rates exists but not show field region.
                                location.reload();
                                return;
                            }
                        }, 2000)
                        $('.cRegionId').hide();
                        $('.cRegion').hide();
                        return false;
                    }
                    if (r.error == true && r.shipping_rates == true && r.region_valid == false) {
                        //Fix asych behavior. (really shipping_rates == true)
                        setTimeout(function() {
                            if ($('#checkout-step-shipping_method .no-quotes-block').length) {
                                $('.cRegionId').hide();
                                $('.cRegion').hide();
                                return false;
                            }
                        }, 2000)
                        $('select', 'div[name="shippingAddress.country_id"]').val(addressData.countryId).change()
                        $('input[name="firstname"]').val(addressData.firstname).change();
                        $('input[name="lastname"]').val(addressData.lastname).change();
                        $('input[name="street[0]"]').val(addressData.street[0]).change();
                        $('input[name="street[1]"]').val(addressData.street[1]).change();
                        $('input[name="city"]').val(addressData.city).change();
                        $('input[name="postcode"]').val(addressData.postcode).change();
                        $('input[name="telephone"]').val(addressData.telephone).change();
                        amazonStorage.isShippingMethodsLoading(false);
                        if ($('.cRegionId').length && $('.cRegion').length) {
                            if ($('.cRegionId select option').length <= 1) {
                                $('.cRegion').show()
                            } else {
                                $('.cRegionId').show()
                            }
                            return;
                        }
                        $('.amazon-widget-container').append($('div[name="shippingAddress.region_id"]').addClass('cRegionId').css({
                            'margin-top': '20px'
                        }))
                        $('.amazon-widget-container').append($('div[name="shippingAddress.region"]').addClass('cRegion').css({
                            'margin-top': '20px'
                        }))
                    }
                }).fail(function(e) {
                    console.log("errore request", e)
                })
            },
            getShippingAddressFromAmazon: function(rds) {
                var serviceUrl, payload;
                amazonStorage.isShippingMethodsLoading(true);
                shippingService.isLoading(true);
                serviceUrl = urlBuilder.createUrl('/amazon-shipping-address/:amazonOrderReference', {
                        amazonOrderReference: amazonStorage.getOrderReference()
                    }),
                    payload = {
                        addressConsentToken: amazonStorage.getAddressConsentToken()
                    };
                storage.put(serviceUrl, JSON.stringify(payload)).done(function(data) {
                    var amazonAddress = data.shift(),
                        addressData = addressConverter.formAddressDataToQuoteAddress(amazonAddress),
                        i;
                    //if telephone is blank set it to 00000000 so it passes the required validation
                    addressData.telephone = !addressData.telephone ? '0000000000' : addressData.telephone;
                    //fill in blank street fields
                    if ($.isArray(addressData.street)) {
                        for (i = addressData.street.length; i <= 2; i++) {
                            addressData.street[i] = '';
                        }
                    }
                    checkoutData.setShippingAddressFromData(addressConverter.quoteAddressToFormAddressData(addressData));
                    checkoutDataResolver.resolveEstimationAddress();
                    if (stepNavigator.getActiveItemIndex() == 0) {
                        //fake asych.
                        amazonStorage.isShippingMethodsLoading(true);
                        setTimeout(function() {
                            rds(addressData, shippingService.getShippingRates())
                        }, 1500)
                    }
                }).fail(function(response) {
                    errorProcessor.process(response);
                    //remove shipping loader and set shipping rates to 0 on a fail
                    shippingService.setShippingRates([]);
                    amazonStorage.isShippingMethodsLoading(false);
                });
            },
            /**
             * Get Amazon Order Reference ID
             */
            getAmazonOrderReference: function() {
                return amazonStorage.getOrderReference();
            },
            /**
             * Get Amazon Address Consent Token
             */
            getAddressConsentToken: function() {
                return amazonStorage.getAddressConsentToken();
            }
        });
    });