<?php

namespace Drop\Amazon\Model;

use Amazon\Payment\Helper\Address;
use Exception;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Webapi\Exception as WebapiException;

/**
 * @deprecated
 */
class ShippingInformationManagement
{
    /**
     * @var \Drop\Amazon\Helper\GoogleMapsGeolocation
     */
    protected $_googleHelper;

    /**
     * @var \Drop\Amazon\Helper\Country
     */
    protected $_countryHelper;

    /**
     * @var \Drop\Amazon\Helper\Country
     */
    protected $_geoHelper;

    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $_quoteRepository;

    public function __construct(
        \Drop\Amazon\Helper\GoogleMapsGeolocation  $googleHelper,
        \Drop\Amazon\Helper\Country                $countryHelper,
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
    ) {
        $this->_googleHelper    = $googleHelper;
        $this->_countryHelper   = $countryHelper;
        $this->_quoteRepository = $quoteRepository;
    }

    /**
     * @param  \Magento\Checkout\Model\ShippingInformationManagement   $subject
     * @param  mixed                                                   $result
     * @param  int                                                     $cartId
     * @param  \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
     * @return mixed
     */
    public function afterSaveAddressInformation(
        \Magento\Checkout\Model\ShippingInformationManagement   $subject,
                                                                $result,
                                                                $cartId,
        \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
    ) {
        $this->addStateOrRegion($cartId);
        return $result;
    }

    public function addStateOrRegion(
        $cartId
    ) {
        /**
         * @var \Magento\Quote\Model\Quote $quote
         */
        $quote = $this->_quoteRepository->getActive($cartId);
        $this->validateQuote($quote);

        $address = $quote->getShippingAddress();

        $stateOrRegion = $address->getRegion() ?? null;
        $countryCode   = $address->getCountryId() ?? null;
        $street        = $address->getStreet()[0] ?? null;
        $city          = $address->getCity() ?? null;
        $zip           = $address->getPostcode() ?? null;

        $this->checkIssetStateOrRegion(
            $stateOrRegion,
            $countryCode,
            $zip,
            $address
        );
    }

    public function checkIssetStateOrRegion(
        $stateOrRegion,
        $countryCode,
        $zip,
        $address
    ) {
        //Se è vuoto non posso procedere.
        if (empty($stateOrRegion)) {
            throw new InputException(__('Please select State/Province'));
        }

        if (empty($zip)) {
            throw new InputException(__('Please insert a valid postcode'));
        }

        //Se non è vuoto verifico se esiste.
        if ($regionId = $this->checkRegionIdInDatabase($stateOrRegion, $countryCode)) {
            if (null !== $address) {
                $address->setRegionId(
                    $regionId
                );

                $address->save();
            }

            return;
        }

        //Se non è vuoto o non esiste
        throw new InputException(__('Amazon could not process your request.'));
    }

    /**
     * @param  string            $stateOrRegion
     * @param  string            $countryCode
     * @throws WebapiException
     * @return int
     */
    public function checkRegionIdInDatabase(
        $stateOrRegion,
        $countryCode
    ) {
        $regionId = $this->_countryHelper->getRegionIdFromDefaultName(
            $stateOrRegion,
            $countryCode
        );

        return $regionId;
    }

    /**
     * Validate quote
     *
     * @param  \Magento\Quote\Model\Quote $quote
     * @throws InputException
     * @throws NoSuchEntityException
     * @return void
     */
    private function validateQuote(\Magento\Quote\Model\Quote $quote)
    {
        if (0 == $quote->getItemsCount()) {
            throw new InputException(__('Shipping method is not applicable for empty cart'));
        }
    }
}
