<?php

namespace Drop\Amazon\Helper;

use Drop\Amazon\Model\GoogleMaps\Data;

/**
 * @deprecated
 */
class GoogleMapsGeolocation extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\HTTP\Client\Curl
     */
    protected $_curl;

    /**
     * @var string
     */
    private $find = 'administrative_area_level_1';

    /**
     * @param \Magento\Framework\HTTP\Client\Curl $curl
     */
    public function __construct(
        \Magento\Framework\HTTP\Client\Curl $curl
    ) {
        $this->_curl = $curl;
    }

    /**
     * @param  string   $street
     * @param  string   $city
     * @param  string   $countryId
     * @return string
     */
    public function findRegionByGoogle(
        $street,
        $city,
        $postCode,
        $countryId
    ) {
        $address = "{$street}, {$city}, ${postCode}, ${countryId}";

        $url = Data::BASE_ENDPOINT . urlencode($address);

        try {
            $this->_curl->get($url);
        } catch (\Exception $e) {
            return null;
        }

        if ($this->_curl->getStatus() != 200) {
            return null;
        }

        return $this->getStateRegion(
            $this->_curl->getBody()
        );
    }

    private function getStateRegion($data)
    {
        $data = json_decode($data, true);

        //Prendo lo stato che ha come short_name due caratteri e administrative_area_level_1
        foreach ($data as $k) {
            foreach ($k[0]['address_components'] ?? [] as $a => $l) {
                if (preg_match("/[A-Z]{2}+/", $l['short_name']) && in_array($this->find, $l['types'])) {
                    return $l['long_name'] ?? null;
                }
            }
        }

        return null;
    }
}
