<?php

namespace Drop\Amazon\Helper;

class Country extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Directory\Model\ResourceModel\Region\CollectionFactory
     */
    protected $_countryCollection;

    /**
     * @param \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $countryCollection
     */
    public function __construct(
        \Magento\Directory\Model\ResourceModel\Region\CollectionFactory $countryCollection
    ) {
        $this->_countryCollection = $countryCollection;
    }

    /**
     * @param  string        $stateOrRegion
     * @param  string        $countryCode
     * @return string|null
     */
    public function getRegionIdFromDefaultName(
        $stateOrRegion,
        $countryCode
    ) {
        $countryCollection = $this->_countryCollection->create();

        $collection = $countryCollection
        //->addFieldToFilter('country_id', ['eq' => $countryCode])
        ->addFieldToFilter('default_name', ['eq' => $stateOrRegion])
            ->setPageSize(1)
            ->setCurPage(1)
            ->load()
        ;

        if ($collection->getSize()) {
            return $collection->getFirstItem()->getRegionId();
        }

        return null;
    }
}
