<?php

namespace Drop\Amazon\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;

/**
 * Custom Amazon controller
 */
class Amazon extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\Controller\Result\Json
     */
    protected $_resultJson;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $_request;

    /**
     * @var \Drop\Amazon\Helper\Country
     */
    protected $_countryHelper;

    /**
     * @param Context                                   $context
     * @param \Magento\Framework\Controller\Result\Json $resultJson
     * @param \Drop\Amazon\Helper\Country               $countryHelper
     */
    public function __construct(
        Context                                   $context,
        \Magento\Framework\Controller\Result\Json $resultJson,
        \Drop\Amazon\Helper\Country               $countryHelper
    ) {
        parent::__construct($context);

        $this->_request       = $context->getRequest();
        $this->_resultJson    = $resultJson;
        $this->_countryHelper = $countryHelper;
    }

    public function execute()
    {
        if ( ! $this->_request->isAjax()) {
            return false;
        }

        $payload = null;

        $addressToCheck = json_decode($this->_request->getContent());

        $stateOrRegion = $addressToCheck->address->region ?? null;
        $countryCode   = $addressToCheck->address->countryId ?? null;

        try {
            $regionId = $this->_countryHelper->getRegionIdFromDefaultName(
                $stateOrRegion,
                $countryCode
            );

            if (null == $regionId) {
                throw new \Exception;
            }

            $payload = ['error' => false, 'region_valid' => true, 'shipping_rates' => $addressToCheck->rates >= 1];
        } catch (\Exception $e) {
            $payload = ['error' => true, 'region_valid' => false, 'shipping_rates' => $addressToCheck->rates >= 1];
        }

        $this->_resultJson->setData($payload);
        return $this->_resultJson;
    }
}
