<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Drop\Adyen\Model;

use Magento\Framework\Exception\CouldNotSaveException;

/**
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class GuestPaymentInformationManagement extends \Magento\Checkout\Model\GuestPaymentInformationManagement
{
    /**
     * {@inheritDoc}
     */
    public function savePaymentInformationAndPlaceOrder(
        $cartId,
        $email,
        \Magento\Quote\Api\Data\PaymentInterface $paymentMethod,
        \Magento\Quote\Api\Data\AddressInterface $billingAddress = null
    ) {
        $salesConnection = $this->getConnectionPull()->getConnection('sales');
        $checkoutConnection = $this->getConnectionPull()->getConnection('checkout');
        $salesConnection->beginTransaction();
        $checkoutConnection->beginTransaction();
        try {
            $this->savePaymentInformation($cartId, $email, $paymentMethod, $billingAddress);
            try {
                $orderId = $this->cartManagement->placeOrder($cartId);
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                \Magento\Framework\App\ObjectManager::getInstance()
                    ->get(\Magento\Checkout\Helper\Data::class)->sendPaymentFailedEmail(
                        $this->getCartRepository()->getActive(
                            $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id')['quote_id']
                        ), 
                        $e->getMessage()
                    );

                throw new CouldNotSaveException(
                    __($e->getMessage()),
                    $e
                );
            } catch (\Exception $e) {
                \Magento\Framework\App\ObjectManager::getInstance()
                    ->get(\Magento\Checkout\Helper\Data::class)->sendPaymentFailedEmail(
                        $this->getCartRepository()->getActive(
                            $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id')['quote_id']
                        ), 
                        $e->getMessage()
                    );
                $this->getLogger()->critical($e);
                throw new CouldNotSaveException(
                    __('An error occurred on the server. Please try to place the order again.'),
                    $e
                );
            }
            $salesConnection->commit();
            $checkoutConnection->commit();
        } catch (\Exception $e) {
            $salesConnection->rollBack();
            $checkoutConnection->rollBack();
            throw $e;
        }
        
        return $orderId;
    }

    /**
     * Get logger instance
     *
     * @return \Psr\Log\LoggerInterface
     * @deprecated 100.2.0
     */
    private function getLogger()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Psr\Log\LoggerInterface::class);
    }

    /**
     * Get Resource Connection
     * 
     * @return \Magento\Framework\App\ResourceConnection
     */
    private function getConnectionPull(){
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Framework\App\ResourceConnection::class);
    }

    /**
     * Get Cart repository
     *
     * @return \Magento\Quote\Api\CartRepositoryInterface
     * @deprecated 100.2.0
     */
    private function getCartRepository()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Quote\Api\CartRepositoryInterface::class);
    }
}