<?php

namespace Drop\AdminProductsToCategory\Block\Adminhtml\Product\Edit\Action\Attribute\Tab;

use \Paulmillband\AdminProductsToCategory\Block\Adminhtml\Product\Edit\Action\Attribute\Tab\CategoryList as PaulCategoryList;

class CategoryList extends PaulCategoryList
{
    /**
     * {@inheritDoc}
     */
    public function getChildCategories($category)
    {
        if ($this->categoryFlatState->isFlatEnabled() && $category->getUseFlatResource()) {
            $subcategories = (array) $category->getChildrenNodes();
        } else {
            $category = $this->getCategoryFactory()->create()->load(
                $category->getId()
            );
            $subcategories = $category->getChildrenCategories();
        }

        return $subcategories;
    }

    /**
     * @return \Magento\Framework\Data\Tree\Node\Collection or
     * \Magento\Catalog\Model\ResourceModel\Category\Collection
     */
    public function getCategoryCollection()
    {
        if(!$this->categoryCollection){
            $this->categoryCollection = $this->getStoreCategories(true, true, true);
        }
        return $this->categoryCollection;
    }

    /**
     * @return \Magento\Catalog\Model\CategoryFactory
     */
    private function getCategoryFactory()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Catalog\Model\CategoryFactory::class);
    }
}
