<?php

/**
 * Description of products out of stock
 * @date 09-apr-2021 10.47.54
 * @author Gianluca Mariani <g.mariani@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\CollectionFactory');
$stockRegistry = $objectManager->create('\Magento\CatalogInventory\Model\StockRegistry');
$stockState = $objectManager->create('\Magento\CatalogInventory\Api\StockStateInterface');


// tutti i prodotti configurabili con visibilità catalog-search e enabled
$collection = $productCollection->create()->addStoreFilter(1)->addAttributeToSelect('entity_id')
    ->addFieldToFilter('type_id', 'configurable')
    ->addAttributeToFilter('visibility', \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH)
    ->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
    ->load();

foreach ($collection as $configProduct) {
    $productObj = $objectManager->create('Magento\Catalog\Model\Product')->load($configProduct->getId());
    // filtro i prodotti semplici
    $usedProducts = $productObj->getTypeInstance()->getUsedProducts($productObj);
    $i = 0;
    foreach ($usedProducts as $childProduct) {
        $productStock = $stockRegistry->getStockItem($childProduct->getId());
        $productQty = $productStock->getQty();
        if ($productQty > 0) {
            $i++;
        }
    }
    if ($i <= 0 && $configProduct->isSaleable()) {
        $stockItem = $stockRegistry->getStockItem(
            $productObj->getId(),
            $productObj->getStore()->getWebsiteId()
        );
        $sku = $configProduct->getSku();
        try {
            $stockItem->setQty(0);
            $stockItem->setIsInStock(false);
            $stockRegistry->updateStockItemBySku($sku, $stockItem);
            $productObj->setIsSalable(false);
        } catch (Exception $e) {
            echo $e->getMessage();
        }
        echo $sku . " impostato out-of-stock" . PHP_EOL;
    }
}
echo PHP_EOL."FINE".PHP_EOL;
