<?php

/**
 * Description of asd
 * @date 11-apr-2018 15.32.04
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');
 
$bootstrap = Bootstrap::create(BP, $_SERVER);
$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);

$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\Collection');
/** Apply filters here */
$products = $productCollection->addAttributeToSelect('*')
    ->addFieldToFilter('type_id', 'simple')
    ->load();

echo PHP_EOL . count($products);
$counter = 0;
if($products->getSize() > 0) {
    foreach($products as $product) {
        if(strpos($product->getSku(), '27ab369f') !== false) {
            continue;
        }
        if(strpos($product->getSku(), '27ab370f') !== false) {
            continue;
        }
        if(strpos($product->getSku(), '27ab371f') !== false) {
            continue;
        }
        if(strpos($product->getSku(), '27gc228') !== false) {
            continue;
        }
        $categories = $product->getCategoryIds();
        if(count($categories) == 0) {
            $counter++;
            echo PHP_EOL . $product->getSku() . " has no category.";
//            die();
        }
    }
}

echo PHP_EOL . "TOTAL WITHOUT CATEGORY: " . $counter;
