<?php

/**
 * Description of products xport
 * @date 18-apr-2019 16.49.24
 * @author Gianluca Mariani <g.mariani@drop.it>
 */
require_once(__DIR__ . '/../bootstrap.php');

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);

$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\CollectionFactory');
$eavModel = $objectManager->create('Magento\Catalog\Model\ResourceModel\Eav\Attribute');

$collection = $productCollection->create()->addStoreFilter(1)->addAttributeToSelect('*')->load();

$fp = fopen(BP."/var/export/export.csv","w+");

foreach ($collection as $product) {
    $productObj = $objectManager->create('Magento\Catalog\Model\Product')->load($product->getId());
    $attributeSet = $objectManager->create('Magento\Eav\Api\AttributeSetRepositoryInterface');
    $attributeSetRepository = $attributeSet->get($product->getAttributeSetId());
    $attribute_set_name = $attributeSetRepository->getAttributeSetName();
    $categories = $product->getCategoryIds();
    $category = [];

    $data = [];
    $data[] = $product->getSku();
    $data[] = $product->getName();
    $data[] = $product->getCreatedAt();
    $data[] = $product->getColorText();
    $data[] = $product->getBarcode();
    $data[] = $product->getPrice();
    $data[] = $productObj->getResource()->getAttribute('season_filter')->getFrontend()->getValue($productObj);
    $data[] = $attribute_set_name;

    foreach ($categories as $categoryId) {
        $category[] = $objectManager->create('Magento\Catalog\Model\Category')->load($categoryId)->getName();
    }
    $data[] = implode(',', $category);
    echo "aggiunto ".$product->getSku().PHP_EOL;
    fputcsv($fp, $data);


}
fclose($fp);
echo "FINE";
