<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
    ->addAttributeToSelect('*');

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
foreach($ordersCollection as $order) {
    echo PHP_EOL . "------------------------";
    echo PHP_EOL . "ORDER: " . $incrementId = $order->getIncrementId() . ' - ' . $order->getId() . PHP_EOL;

    echo PHP_EOL . "SHIPPING AMOUNT: " . $shippingAmount = $order->getShippingAmount();
    echo PHP_EOL . "SHIPPING TAX AMOUNT: " . $shippingTaxAmount = $order->getShippingTaxAmount();


    echo PHP_EOL . "CALCULATED SHIPPING TAXES: " . $calculatedShippingTaxes = number_format(($shippingAmount * 22)/100, 2);

    if($calculatedShippingTaxes == $shippingTaxAmount) {
        echo PHP_EOL . "TUTTO OK";
        continue;
    }

    try {
        if($order->getData('base_shipping_canceled') != 0 || $order->getData('shipping_canceled') != 0) {
            if($order->getData('base_shipping_canceled') != number_format($shippingAmount, 2)) {
                echo PHP_EOL . "base_shipping_canceled: " . $order->getData('base_shipping_canceled');
                die('<br/>' . __METHOD__ . '1');
            }
        }
        if($order->getData('base_shipping_invoiced') != 0 || $order->getData('shipping_invoiced') != 0) {
            if($order->getData('base_shipping_invoiced') != number_format($shippingAmount, 2)) {
                $order->setBaseShippingInvoiced($shippingAmount);
                $order->setShippingInvoiced($shippingAmount);
                echo PHP_EOL . "DIFFERENT SHIPPING INVOICED ERROR: " . $order->getData('base_shipping_invoiced');
                echo PHP_EOL . "ShippingInvoiced " . $shippingAmount;
            }
        }
        if($order->getData('base_shipping_refunded') != 0 || $order->getData('shipping_refunded') != 0) {
            if($order->getData('base_shipping_refunded') != number_format($shippingAmount, 2)) {
                echo PHP_EOL . "base_shipping_refunded: " . $order->getData('base_shipping_refunded');
                die('<br/>' . __METHOD__ . '1');
            }
        }

        if($order->getData('base_shipping_tax_refunded') != 0 || $order->getData('shipping_tax_refunded') != 0) {
            if($order->getData('base_shipping_tax_refunded') != number_format($shippingTaxAmount, 2)) {
                echo PHP_EOL . "base_shipping_tax_refunded: " . $order->getData('base_shipping_tax_refunded');
                if($order->getId() != 1387) {
                    die('<br/>' . __METHOD__ . '1');
                }
            }
        }

        $order->setBaseShippingTaxAmount($calculatedShippingTaxes);
        $order->setShippingTaxAmount($calculatedShippingTaxes);
        $order->setBaseShippingInclTax($shippingAmount + $calculatedShippingTaxes);
        $order->setShippingInclTax($shippingAmount + $calculatedShippingTaxes);
        $order->save();

        echo PHP_EOL . PHP_EOL . "SETTATO";
        echo PHP_EOL . "ShippingTaxAmount " . $calculatedShippingTaxes;
        echo PHP_EOL . "ShippingInclTax " . ($shippingAmount + $calculatedShippingTaxes);

    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }
}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
