<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$customersFactory = $objectManager->get('Magento\Customer\Model\ResourceModel\Customer\CollectionFactory');
$orderFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$customersCollection = $customersFactory->create()
    ->addAttributeToSelect('*');

echo PHP_EOL . "ROW COUNT: " . $customersCollection->count();

$deleteCounter = 0;
$cannotDeleteCounter = 0;
foreach($customersCollection as $customer) {
    $ipAddress = $customer->getIpAddress();
    if(empty($ipAddress)) {
        echo PHP_EOL . "--------------------------------";
        echo PHP_EOL . "Empty customer IP address ID: " . $customerId = $customer->getId();
        $customerOrdersCollection = $orderFactory->create()->addFieldToSelect('*')->addFieldToFilter('customer_id', $customerId);
        echo PHP_EOL . "Orders: " . $ordersNumber = $customerOrdersCollection->count();
        if($ordersNumber != 0) {
            echo PHP_EOL . "CANNOT DELETE. HAS ORDER";
            $cannotDeleteCounter++;
            continue;
        } else {
            try {
//                $customer->delete();
                $deleteCounter++;
            } catch (\Exception $e) {
                echo PHP_EOL . "CANNOT DELETE CUSTOMER: " . $customerId . ' - ' . $e->getMessage();
                die(PHP_EOL);
            }
        }
    }
}

echo PHP_EOL . "DELETE TOTAL COUNTER: " . $deleteCounter;
echo PHP_EOL . "CANNOT DELETE TOTAL COUNTER: " . $cannotDeleteCounter;
