<?php
/**
 * Created by PhpStorm.
 * User: marcoprontera
 * Date: 12/05/20
 * Time: 17.32
 */

if($argv[1] !== "--live"){
    echo "Aggiorna le variabili e se sei sicuro aggiungi l'argomento --live per l'esecuzione";
    return;
}

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$invoiceFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory');

$idLastCorrect = 9614;
$prefixFe = 'JE-2020-';
$lastFeIncrement = 2790;



$invoicesCollection = $invoiceFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('entity_id', ['gteq' => $idLastCorrect]);


$file = 'prepare-sql-for-sales-invoice-grid.txt';
$current = "";
file_put_contents($file, "");

$docType = 'Accompagnatoria';
foreach ($invoicesCollection as $invoice) {
    $fe_incremend_id = null;
    try {
        if (floor(log10($lastFeIncrement) + 1) == 4) {
            $fe_incremend_id = $prefixFe . '0' . $lastFeIncrement;
        } else {
            $fe_incremend_id = $prefixFe . $lastFeIncrement;
        }
        $entityId = $invoice->getEntityId();
        $invoice
            ->setIncrementId($fe_incremend_id)
            ->setFeIncrementId($fe_incremend_id)
            ->setDocumentType($docType)
            ->save();

        $current .= "UPDATE `sales_invoice_grid` SET`increment_id`='$fe_incremend_id',`fe_increment_id`='$fe_incremend_id' WHERE `entity_id` LIKE $entityId;\n";

        $lastFeIncrement++;

    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }
}
file_put_contents($file, $current);

echo "Ora prendi le query dentro il file txt e buttale dentro PMA";