<?php

/**
 * Description of products image delete
 * @date 10-jun-2020 14.50.22
 * @author Gianluca Mariani <g.mariani@drop.it>
 */
require_once(__DIR__ . '/../bootstrap.php');

$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
$appState = $objectManager->get('\Magento\Framework\App\State');
$productRepository = $objectManager->create('Magento\Catalog\Api\ProductRepositoryInterface');
$appState->setAreaCode('frontend');

// NB. cancella le immagini sia dei configurabili che dei semplici "figli"
$products = ["sku1","sku2"];
echo PHP_EOL;
foreach ($products as $sku) {
    $productFactory = $objectManager->create(\Magento\Catalog\Model\ProductFactory::class);
    $product = $productFactory->create()->loadByAttribute('sku', $sku);
    $product = $objectManager->get('Magento\Catalog\Model\Product')->load($product->getId());

    $existingMediaGalleryEntries = $product->getMediaGalleryEntries();
    foreach ($existingMediaGalleryEntries as $key => $entry) {
        unset($existingMediaGalleryEntries[$key]);
        echo "immagini prodotto configurabile " . $sku . " cancellate" . PHP_EOL;
    }
    $product->setMediaGalleryEntries($existingMediaGalleryEntries);
    $productRepository->save($product);

    if ($product->getTypeId() == "configurable") {
        $simpleProducts = $product->getTypeInstance()->getUsedProducts($product);

        foreach ($simpleProducts as $simple) {
            $simpleProduct = $productFactory->create()->loadByAttribute('sku', $simple->getSku());
            $simpleProduct = $objectManager->get('Magento\Catalog\Model\Product')->load($simpleProduct->getId());

            $existingMediaGalleryEntries = $simpleProduct->getMediaGalleryEntries();
            foreach ($existingMediaGalleryEntries as $key => $entry) {
                unset($existingMediaGalleryEntries[$key]);
                echo "immagini prodotto semplice " . $simple->getSku() . " cancellate" . PHP_EOL;

            }
            $simpleProduct->setMediaGalleryEntries($existingMediaGalleryEntries);
            $productRepository->save($simpleProduct);
        }
    }
}
