<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$invoiceFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory');

$invoicesCollection = $invoiceFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('msp_cod_amount', ['neq' => 0]);

echo PHP_EOL . "ROW COUNT: " . $invoicesCollection->count();

$changeCounter = 0;
foreach($invoicesCollection as $invoice) {
    $incrementId = $invoice->getIncrementId();

    $baseCodAmount = $invoice->getBaseMspCodAmount();
    $codAmount = $invoice->getMspCodAmount();
    $baseCodTaxAmount = $invoice->getBaseMspCodTaxAmount();
    $codTaxAmount = $invoice->getMspCodTaxAmount();

    $calculatedBaseCodTaxAmount = ($baseCodAmount*22)/100;
    $calculatedCodTaxAmount = ($codAmount*22)/100;

    if((abs($calculatedBaseCodTaxAmount - $baseCodTaxAmount) < 0.0001) && (abs($calculatedCodTaxAmount - $codTaxAmount) < 0.0001)) {
        continue;
    }

    echo PHP_EOL . "--------------------------------------";
    echo PHP_EOL . "INCREMENT: " . $incrementId;
    echo PHP_EOL;
    echo PHP_EOL . "EXPECTED BASE TAX WRONG FOR COD: " . $baseCodAmount . ': ' . $calculatedBaseCodTaxAmount . ' (' . $baseCodTaxAmount . ')';
    echo PHP_EOL . "EXPECTED TAX WRONG FOR COD: " . $codAmount . ': ' . $calculatedCodTaxAmount . ' (' . $codTaxAmount . ')';

    try {
        $invoice->setBaseMspCodTaxAmount($calculatedBaseCodTaxAmount)
            ->setMspCodTaxAmount($calculatedCodTaxAmount)
            ->save();
        echo PHP_EOL . "INVOICE SAVED";
        $changeCounter++;
//        sleep(1);
    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }

}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
