<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$customersFactory = $objectManager->get('Magento\Customer\Model\ResourceModel\Customer\CollectionFactory');
$customerFactory = $objectManager->get('Magento\Customer\Model\CustomerFactory');
$customerRepositoryInterface  = $objectManager->get('Magento\Customer\Api\CustomerRepositoryInterface');
$orderFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$customersCollection = $customersFactory->create()
    ->addAttributeToSelect('*');

echo PHP_EOL . "ROW COUNT: " . $customersCollection->count();

$changeCounter = 0;
foreach($customersCollection as $customer) {
    $privacyPolicyAccepted = $customer->getIsPrivacyPolicyAccepted();
    if(empty($privacyPolicyAccepted)) {
        echo PHP_EOL . "--------------------------------";
        echo PHP_EOL . "Empty privacy policy acceptance for ID: " . $customerId = $customer->getId();
        try {
            //Bisogna per forza ricaricare il customer e settarlo così altrimenti non salva
            $saveCustomer = $customerFactory->create()->load($customerId)->getDataModel();
            $saveCustomer->setCustomAttribute('is_privacy_policy_accepted', '1');
            $customerRepositoryInterface->save($saveCustomer);
            echo PHP_EOL . $customerId . " SAVED";
            $changeCounter++;
        } catch (\Exception $e) {
            echo PHP_EOL . "CANNOT SAVE CUSTOMER: " . $customerId . ' - ' . $e->getMessage();
            die(PHP_EOL);
        }
    }
}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
