<?php

/**
 * Description of asd
 * @date 11-apr-2018 15.32.04
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$categoryFactory = $objectManager->get('Magento\Catalog\Model\CategoryFactory');
$newCategory = $categoryFactory->create();
$collection = $newCategory->getCollection();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);

foreach ($collection as $category) {
    $category_id = $category->getId();

    if ($category_id <= 2) {
        continue;
    }

    try {
        $category->delete();
        echo 'Category Removed ' . $category_id . PHP_EOL;
    } catch (\Exception $e) {
        echo 'Failed to remove category ' . $category_id . PHP_EOL;
        echo $e->getMessage() . "\n" . PHP_EOL;
    }
}
