<?php

/**
 * Description of taxes-fix-calculation-for-discount
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$creditmemosFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Creditmemo\CollectionFactory');

$creditmemosCollection = $creditmemosFactory->create()
            ->addAttributeToSelect('*')
            ->addAttributeToFilter('discount_amount', ['neq' => 'NULL']);

echo PHP_EOL . "ROW COUNT: " . $creditmemosCollection->count();

$changeCounter = 0;
foreach($creditmemosCollection as $creditmemo) {
    $shippingAddress = $creditmemo->getShippingAddress();
    $country = $shippingAddress->getCountryId();
    if($country != 'IT') {
        //Aggiungo controllo per IT
        continue;
    }

    $totalPaid = $creditmemo->getGrandTotal();
    $currentTaxValue = $creditmemo->getTaxAmount();
    $rightTaxValue = number_format($totalPaid - ($totalPaid/1.22), 4);

    if($currentTaxValue != $rightTaxValue) {
        echo PHP_EOL . "CREDITMEMO: " . $incrementId = $creditmemo->getIncrementId();
        echo " - TOTAL PAID: " . $totalPaid;
        echo " - CURRENT TAX VALUE: " . $currentTaxValue;
        echo " - RIGHT TAX VALUE: " . $rightTaxValue;

//        try {
//            $creditmemo->setBaseTaxAmount($rightTaxValue)
//                ->setTaxAmount($rightTaxValue)
//                ->save();
//            $changeCounter++;
//        } catch (\Exception $e) {
//            echo PHP_EOL . "CANNOT SAVE CREDITMEMO: " . $incrementId . ' - ' . $e->getMessage();
//        }
    }
}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
