<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$subscribersFactory = $objectManager->get('\Magento\Newsletter\Model\ResourceModel\Subscriber\CollectionFactory');
$customerRepositoryInterface = $objectManager->get('\Magento\Customer\Api\CustomerRepositoryInterface');

$subscribersCollection = $subscribersFactory->create();
echo PHP_EOL . "ROW COUNT: " . $subscribersCollection->count();

$deleteCounter = 0;
$syncCounter = 0;
foreach($subscribersCollection as $subscriber) {
    if(!empty($subscriber->getIpAddress())) {
        continue;
    }

    $customerId = $subscriber->getCustomerId();
    if(empty($customerId)) {
        continue;
    }

    try {
        $customer = $customerRepositoryInterface->getById($customerId);
    } catch (\Exception $e) {
        deleteSubscriber($subscriber);
        continue;
    }

    if(!$customer->getCustomAttribute('ip_address') || empty($customer->getCustomAttribute('ip_address'))) {
        $deleteCounter++;
        deleteSubscriber($subscriber);
        continue;
    }

    $customerIp = $customer->getCustomAttribute('ip_address')->getValue();
    if(empty($customerIp)) {
        $deleteCounter++;
        deleteSubscriber($subscriber);
        continue;
    }

    try {
        echo PHP_EOL . "SYNC SUBSCRIBER {$subscriber->getSubscriberId()} WITH IP: {$customerIp}";
//        $subscriber->setIpAddress($customerIp)->save();
        $syncCounter++;
    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }
}

function deleteSubscriber($subscriber) {
    try {
        echo PHP_EOL . "DELETE SUBSCRIBER {$subscriber->getSubscriberId()}";
//        $subscriber->delete();
    } catch (Exception $e) {
        echo "<br/>" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }
}

echo PHP_EOL . "DELETE TOTAL COUNTER: " . $deleteCounter;
echo PHP_EOL . "SYNC TOTAL COUNTER: " . $syncCounter;
