<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$shipmentFactory = $objectManager->get('\Magento\Sales\Model\ResourceModel\Order\Shipment\CollectionFactory');
$resourceConnection = $objectManager->get('\Magento\Framework\App\ResourceConnection');
$connection = $resourceConnection->getConnection('sales');
$shipmentGridTableName = $resourceConnection->getTableName('sales_shipment_grid');

$shipmentCollection = $shipmentFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('total_qty', ['null' => true]);

echo PHP_EOL . "" . $shipmentCollection->count();

foreach($shipmentCollection as $shipment) {

    echo PHP_EOL . "shipment getId " . $shipmentId = $shipment->getId();
    echo PHP_EOL . "shipment getIncrementId " . $shipmentIncrementId = $shipment->getIncrementId();
    $order = $shipment->getOrder();
    echo PHP_EOL . "order getId " . $orderId = $order->getId();
    echo PHP_EOL . "order getIncrementId " . $orderIncrementId = $order->getIncrementId();

    echo PHP_EOL . "order getStoreId " . $orderStoreId = $order->getStoreId();
    echo PHP_EOL . "order getTotalQtyOrdered " . $orderTotalQty = $order->getTotalQtyOrdered();
    echo PHP_EOL . "order getCustomerIsGuest " . $customerIsGuest = $order->getCustomerIsGuest();
    echo PHP_EOL . "order getBillingAddressId " . $billingAddressId = $order->getBillingAddressId();
    echo PHP_EOL . "order getShippingAddressId " . $shippingAddressId = $order->getShippingAddressId();

    $orderGridFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Grid\CollectionFactory');
    $orderGrid = $orderGridFactory->create()
        ->addFieldToFilter('increment_id', ['eq' => $orderIncrementId])
        ->getFirstItem();

    echo PHP_EOL . "ordergrid getBillingAddress " . $orderGridBillingAddress = $orderGrid->getBillingAddress();
    echo PHP_EOL . "ordergrid getShippingAddress " . $orderGridShippingAddress = $orderGrid->getShippingAddress();
    echo PHP_EOL . "ordergrid getBillingName " . $orderGridBillingName = $orderGrid->getBillingName();
    echo PHP_EOL . "ordergrid getShippingName " . $orderGridShippingName = $orderGrid->getShippingName();
    echo PHP_EOL . "ordergrid getCustomerName " . $orderGridCustomerName = $orderGrid->getCustomerName();
    echo PHP_EOL . "ordergrid getCustomerGroup " . $orderGridCustomerGroup = $orderGrid->getCustomerGroup();

    $shipmentGridFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Shipment\Grid\CollectionFactory');
    $shipmentGrid = $shipmentGridFactory->create()
        ->addFieldToFilter('increment_id', ['eq' => $shipmentIncrementId])
        ->getFirstItem();
    $shipmentGridId = $shipmentGrid->getId();

    $orderItems = $order->getItems();
    $shippingItems = $shipment->getItems();

    unset($shippingItemsData);
    $shippingItemsData = [];
    foreach($orderItems as $orderItem) {
        echo PHP_EOL . "orderItem getId " . $orderItem->getId();
        $shippingItemsData[$orderItem->getId()] = $orderItem->getData();
    }

    try {
        //SHIPPING
        $shipment->setStoreId($orderStoreId);
        $shipment->setTotalQty($orderTotalQty);
        if(!$customerIsGuest) {
            $shipment->setCustomerId($customerIsGuest);
        }
        $shipment->setShippingAddressId($billingAddressId);
        $shipment->setBillingAddressId($shippingAddressId);
//        $shipment->save();
        echo PHP_EOL . "SHIPMENT {$shipmentId} UPDATED CORRECTLY";

        //SHIPPING GRID
        $shipmentGrid->setStoreId($orderStoreId);
        if(!$customerIsGuest) {
            $shipmentGrid->setCustomerName($orderGridCustomerName);
            $shipmentGrid->setCustomerGroupId($orderGridCustomerGroup);
        } else {
            $shipmentGrid->setCustomerGroupId(0);
        }
        $shipmentGrid->setTotalQty($orderTotalQty);
        $shipmentGrid->setBillingAddress($orderGridBillingAddress);
        $shipmentGrid->setShippingAddress($orderGridShippingAddress);
        $shipmentGrid->setBillingName($orderGridBillingName);
        $shipmentGrid->setShippingName($orderGridShippingName);

        $shipmentGridData = $shipmentGrid->getData();
        unset($shipmentGridData['id_field_name']);
        unset($shipmentGridData['orig_data']);

        $connection->update($shipmentGridTableName,
            $shipmentGridData,
            ['entity_id = ?' => (int)$shipmentGridId]);
        echo PHP_EOL . "SHIPMENT GRID {$shipmentGridId} UPDATED CORRECTLY";

        //SHIPPING ITEMS
        foreach($shippingItems as $shippingItem) {
            if(array_key_exists($shippingItem->getOrderItemId(), $shippingItemsData)) {
                $shippingItem->addData($shippingItemsData[$shippingItem->getOrderItemId()]);
//                $shippingItem->save();
                unset($shippingItemsData[$shippingItem->getOrderItemId()]);
                echo PHP_EOL . "SHIPMENT ITEM {$shippingItem->getId()} UPDATED CORRECTLY";
            }
        }

        foreach($shippingItemsData as $shippingItemToCreateData) {
            $shipmentItemFactory = $objectManager->get('\Magento\Sales\Model\Order\Shipment\Item');
            $shipmentItemFactory->setData([
                'parent_id' => $shipmentId,
                'row_total' => $shippingItemToCreateData['row_total'],
                'price' => $shippingItemToCreateData['price'],
                'weight' => $shippingItemToCreateData['weight'],
                'qty' => $shippingItemToCreateData['qty_invoiced'],
                'product_id' => $shippingItemToCreateData['product_id'],
                'order_item_id' => $shippingItemToCreateData['item_id'],
                'additional_data' => $shippingItemToCreateData['additional_data'],
                'description' => $shippingItemToCreateData['description'],
                'name' => $shippingItemToCreateData['name'],
                'sku' => $shippingItemToCreateData['sku'],
            ]);
//            $shipmentItemFactory->save();
        }

        foreach($orderItems as $orderItem) {
            $orderItem->setQtyShipped($orderItem->getQtyInvoiced());
//            $orderItem->save();
        }

    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
    }

}

die('<br/>' . __METHOD__ . '2');
