<?php

/**
 * Description of taxes-fix-calculation-for-discount
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$invoicesFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory');

$invoicesCollection = $invoicesFactory->create()
            ->addAttributeToSelect('*')
            ->addAttributeToFilter('discount_amount', ['neq' => 'NULL']);

echo PHP_EOL . "ROW COUNT: " . $invoicesCollection->count();

$changeCounter = 0;
foreach($invoicesCollection as $invoice) {
    $shippingAddress = $invoice->getShippingAddress();
    $country = $shippingAddress->getCountryId();
    if($country != 'IT') {
        //Aggiungo controllo per IT
        continue;
    }

    $totalPaid = $invoice->getGrandTotal();
    $currentTaxValue = $invoice->getTaxAmount();
    $rightTaxValue = number_format($totalPaid - ($totalPaid/1.22), 4);

    if($currentTaxValue != $rightTaxValue) {
        echo PHP_EOL . "INVOICE: " . $incrementId = $invoice->getIncrementId();
        echo " - TOTAL PAID: " . $totalPaid;
        echo " - CURRENT TAX VALUE: " . $currentTaxValue;
        echo " - RIGHT TAX VALUE: " . $rightTaxValue;

//        try {
//            $invoice->setBaseTaxAmount($rightTaxValue)
//                ->setTaxAmount($rightTaxValue)
//                ->save();
//            $changeCounter++;
//        } catch (\Exception $e) {
//            echo PHP_EOL . "CANNOT SAVE INVOICE: " . $incrementId . ' - ' . $e->getMessage();
//        }
    }
}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
