<?php

/**
 * Description of products assign category
 * @date 02-jul-2019 17.39.12
 * @author Gianluca Mariani <g.mariani@drop.it>
 */
require_once(__DIR__ . '/../bootstrap.php');

$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

// categoria/e da aggiungere ai prodotti
$idCategory = ["517"];
$products = ["sku1","sku2","sku3"];

foreach ($products as $sku) {
    $productFactory = $objectManager->create(\Magento\Catalog\Model\ProductFactory::class);
    $productObj = $productFactory->create()->loadByAttribute('sku', $sku);
    if ($productObj && $productObj->getTypeId() === 'configurable') {
        try {
            if (!array_diff($idCategory, $productObj->getCategoryIds())) {
                echo "STOP - categoria già presente sul prodotto " . $sku . PHP_EOL;
                continue;
            }
            $productObj->setCategoryIds(array_merge($productObj->getCategoryIds(), $idCategory));
            $productObj->save();
            echo "OK - categoria aggiunta al prodotto " . $sku . PHP_EOL;
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    } else {
        echo "ERRORE - SKU " . $sku . " ERRATO?" . PHP_EOL;
    }
}
