<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
    ->addAttributeToSelect('*');

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
foreach($ordersCollection as $order) {

    $invoice = $order->getInvoiceCollection()->getFirstItem();
    if(!is_object($invoice) || empty($invoice->getData())) {
        continue;
    }

    $taxInvoiced = $order->getTaxInvoiced();
    $invoiceTaxAmount = $invoice->getTaxAmount();

    if($taxInvoiced != $invoiceTaxAmount) {
        echo PHP_EOL . "ORDER: " . $incrementId = $order->getIncrementId() . ' - ' . $order->getId();
        echo PHP_EOL . "ORDER TAX INVOICED: " . $taxInvoiced;
        echo PHP_EOL . "INVOICE: " . $invoiceIncrementId = $invoice->getIncrementId() . ' - ' . $invoice->getId();
        echo PHP_EOL . "INVOICE TAX: " . $invoiceTaxAmount;

        try {
            $order
                ->setBaseTaxInvoiced($invoiceTaxAmount)
                ->setTaxInvoiced($invoiceTaxAmount)
                ->save();
        } catch (\Exception $e) {
        echo PHP_EOL . "CANNOT SAVE ORDER: " . $incrementId . ' - ' . $e->getMessage();
            die(PHP_EOL . $e->getMessage());
        }
    }

}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
