<?php

/**
 * Description of products-filter.php
 * @date 23-mar-2020 15.32.04
 * @author Gianluca Mariani <g.mariani@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\CollectionFactory');
$stockRegistry = $objectManager->create('\Magento\CatalogInventory\Model\StockRegistry');
$stockState = $objectManager->create('\Magento\CatalogInventory\Api\StockStateInterface');

// tutti i prodotti configurabili con visibilità catalog-search e enabled
$collection = $productCollection->create()->addStoreFilter(1)->addAttributeToSelect('entity_id')
    ->addFieldToFilter('type_id', 'configurable')
    ->addAttributeToFilter('visibility', \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH)
    ->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
    ->load();

$fp = fopen(BP . "/var/export/export.csv", "w+");
$sku = '';

foreach ($collection as $product) {
    $productObj = $objectManager->create('Magento\Catalog\Model\Product')->load($product->getId());
    // filtro i prodotti semplici abilitati e con stock
    $usedProducts = $productObj->getTypeInstance()->getSalableUsedProducts($productObj, null);
    $categories = $product->getCategoryIds();
    foreach ($categories as $categoryId) {
        $category[] = $objectManager->create('Magento\Catalog\Model\Category')->load($categoryId)->getName();
    }

    // controllo se i prodotti hanno almeno una categoria assegnata
    if (!empty($category)) {
        foreach ($usedProducts as $child) {
            // per sicurezza ricontrollo che ogni semplice associato sia enabled e con stock
            if ($child->isSaleable()) {
                if (substr($child->getSku(), -4, 1) == '-') {
                    if ($sku && $sku == substr($child->getSku(), 0, -4)) {
                        echo "salto duplicato " . $sku . PHP_EOL;
                        continue;
                    } else {
                        $sku = substr($child->getSku(), 0, -4);
                    }
                } elseif (substr($child->getSku(), -3, 1) == '-') {
                    if ($sku && $sku == substr($child->getSku(), 0, -3)) {
                        echo "salto duplicato " . $sku . PHP_EOL;
                        continue;
                    } else {
                        $sku = substr($child->getSku(), 0, -3);
                    }
                } elseif (substr($child->getSku(), -2, 1) == '-') {
                    if ($sku && $sku == substr($child->getSku(), 0, -2)) {
                        echo "salto duplicato " . $sku . PHP_EOL;
                        continue;
                    } else {
                        $sku = substr($child->getSku(), 0, -2);
                    }
                } else {
                    echo "sku anomalo: " . $child->getSku() . PHP_EOL;
                    die("STOP");
                }
                // scrivo gli sku semplici risultanti escludendo i duplicati
                $data = [];
                $data[] = $sku;
                echo "aggiunto " . $sku . PHP_EOL;
                fputcsv($fp, $data);
            }
        }
    }
}
fclose($fp);
echo "-----FINE-----".PHP_EOL;
