<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('discount_amount', ['neq' => 0]);

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
foreach($ordersCollection as $order) {
    $discountTaxCompensationAmount = $order->getDiscountTaxCompensationAmount();
    $discountAmount = $order->getDiscountAmount();
    $discountAmountTax = abs(number_format($discountAmount - ($discountAmount/1.22), 2));

    if(abs($discountTaxCompensationAmount - $discountAmountTax) < 0.01) {
        continue;
    }

    echo PHP_EOL . "ORDER: " . $order->getIncrementId() . ' - ' . $order->getId();
    echo PHP_EOL . "DISCOUNT AMOUNT: " . $discountAmount;
    echo PHP_EOL . "DISCOUNT AMOUNT TAX: " . $discountAmountTax;
    echo PHP_EOL . "getDiscountTaxCompensationAmount: " . $discountTaxCompensationAmount;
    echo PHP_EOL . "getDiscountTaxCompensationInvoiced: " . $order->getDiscountTaxCompensationInvoiced();

    $saveInvoice = false;
    $invoice = $order->getInvoiceCollection()->getFirstItem();
    if(is_object($invoice) && !empty($invoice->getData())) {
        $saveInvoice = true;
    }

    try {
        $order->setBaseDiscountTaxCompensationAmount($discountAmountTax)
            ->setDiscountTaxCompensationAmount($discountAmountTax);

        if($saveInvoice) {
            $order->setBaseDiscountTaxCompensationInvoiced($discountAmountTax)
                ->setDiscountTaxCompensationInvoiced($discountAmountTax);
        }

        $order->save();
    } catch (\Exception $e) {
    echo PHP_EOL . "CANNOT SAVE ORDER: " . $incrementId . ' - ' . $e->getMessage();
        die(PHP_EOL . $e->getMessage());
    }

}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
