<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('msp_cod_amount', ['neq' => 0]);

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
foreach($ordersCollection as $order) {
    $incrementId = $order->getIncrementId();

    $baseCodAmount = $order->getBaseMspCodAmount();
    $codAmount = $order->getMspCodAmount();
    $baseCodTaxAmount = $order->getBaseMspCodTaxAmount();
    $codTaxAmount = $order->getMspCodTaxAmount();

    $calculatedBaseCodTaxAmount = ($baseCodAmount*22)/100;
    $calculatedCodTaxAmount = ($codAmount*22)/100;

    if((abs($calculatedBaseCodTaxAmount - $baseCodTaxAmount) < 0.0001) && (abs($calculatedCodTaxAmount - $codTaxAmount) < 0.0001)) {
        continue;
    }

    echo PHP_EOL . "--------------------------------------";
    echo PHP_EOL . "INCREMENT: " . $incrementId;
    echo PHP_EOL;
    echo PHP_EOL . "EXPECTED BASE TAX WRONG FOR COD: " . $baseCodAmount . ': ' . $calculatedBaseCodTaxAmount . ' (' . $baseCodTaxAmount . ')';
    echo PHP_EOL . "EXPECTED TAX WRONG FOR COD: " . $codAmount . ': ' . $calculatedCodTaxAmount . ' (' . $codTaxAmount . ')';

    try {
//        $order->setBaseMspCodTaxAmount($calculatedBaseCodTaxAmount)
//            ->setMspCodTaxAmount($calculatedCodTaxAmount)
//            ->save();
//        echo PHP_EOL . "ORDER SAVED";
        $changeCounter++;
        sleep(1);
    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }

}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
