<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
    ->addAttributeToSelect('*');

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
$productTaxesBiggerThanOrderTaxes = [];
foreach($ordersCollection as $order) {

    echo PHP_EOL . "-------------------";
    echo PHP_EOL . "ORDER: " . $incrementId = $order->getIncrementId();
    echo ' - ' . $order->getId();

    $itemTaxesTotal = 0;
    $orderTaxPercent = 0;
    $itemOriginalPriceTotal = 0;
    $rowTotalTotal = 0;
    $itemsUpdated = false;
    $orderItems = $order->getItems();
    foreach($orderItems as $item) {

        echo PHP_EOL . PHP_EOL . "ITEM: " . $item->getId() . ' - ' . $item->getSku() . ' - ' . $item->getName();
        echo PHP_EOL . "ORIGINAL PRICE: " . $originalPrice = $item->getOriginalPrice();
        echo PHP_EOL . "PRICE: " . $price = $item->getPrice();
        echo PHP_EOL . "QTY: " . $qty = $item->getQtyOrdered();
        echo PHP_EOL . "ALL QTY ORIGINAL PRICES: " . $allQtyOriginalPrice = $originalPrice * $qty;
        echo PHP_EOL . "ALL QTY PRICES: " . $allQtyPrice = $price * $qty;
        echo PHP_EOL . "DISCOUNT AMOUNT: " . $discountAmount = $item->getDiscountAmount();
        echo PHP_EOL . "TAX PERCENT: " . $taxPercent = $item->getTaxPercent();
        echo PHP_EOL . "TAX AMOUNT: " . $taxAmount = $item->getTaxAmount();
        echo PHP_EOL . "ROW TOTAL: " . $item->getRowtotal();

        if($originalPrice == 0 || $price == 0) {
            echo PHP_EOL . "SKIPPED. ";
            continue;
        }
        if($discountAmount == 0) {
            $rowTotalTotal += $allQtyPrice;
            echo PHP_EOL . "DISCOUNT AMOUNT 0. SKIPPED";
            continue;
        }

        $orderTaxPercent = $taxPercent;
        $taxCalculatedBeforeDiscount = number_format(number_format((($allQtyOriginalPrice * $taxPercent)/($taxPercent + 100)), 2), 4);
//        $taxCalculatedBeforeDiscount = number_format(number_format((($allQtyPrice * $taxPercent)/(100)), 2), 4);
        if ($taxCalculatedBeforeDiscount < 0) {
            echo PHP_EOL . "CALCULATED BEFORE TAX AMOUNT: " . $taxCalculatedBeforeDiscount;
            echo PHP_EOL . "ERRORE. TASSE CALCOLATE BVEFORE DISCOUNT NEGATIVE";
            die('<br/>' . __METHOD__ . '1');
        }

        if($taxAmount == $taxCalculatedBeforeDiscount) {}

        $taxCalculatedAfterDiscount = number_format(number_format(((($allQtyOriginalPrice-$discountAmount) * $taxPercent)/($taxPercent + 100)), 2), 4);
//        $taxCalculatedAfterDiscount = number_format(number_format(((($allQtyPrice-($discountAmount/1.22)) * $taxPercent)/(100)), 2), 4);
        if ($taxCalculatedAfterDiscount < 0) {
            echo PHP_EOL . "CALCULATED AFTER TAX AMOUNT: " . $taxCalculatedAfterDiscount;
            echo PHP_EOL . "ERRORE. TASSE CALCOLATE AFTER DISCOUNT NEGATIVE";
            die('<br/>' . __METHOD__ . '1');
        }

        if(($taxAmount == $taxCalculatedAfterDiscount)) {
            echo PHP_EOL . "CURRENT TAX AMOUNT: " . $taxAmount;
            echo PHP_EOL . "CALCULATED AFTER TAX AMOUNT: " . $taxCalculatedAfterDiscount;
            $itemTaxesTotal += $taxCalculatedAfterDiscount;
            $itemOriginalPriceTotal += $allQtyOriginalPrice;
            $rowTotalTotal += $allQtyPrice;
            echo PHP_EOL . "IS OK. SKIPPING. ";
            continue;
        }

        echo PHP_EOL . "CALCULATED BEFORE TAX AMOUNT: " . $taxCalculatedBeforeDiscount;
        echo PHP_EOL . PHP_EOL . "TAX AMOUNT WRONG BECAUSE WAS CALCULATED BEFORE DISCOUNT.";
        echo PHP_EOL . "RIGHT CALCULATED AFTER DISCOUNT ITEM TAX: " . $taxCalculatedAfterDiscount;
        echo PHP_EOL . "ROW TOTAL AFTER CALCULATION " . $allQtyPrice;
        echo PHP_EOL . "DISCOUNT TAX COMPENSATION AMOUNT" . ($allQtyOriginalPrice - $taxCalculatedAfterDiscount - $rowTotal);

        try {
            $item ->setBaseTaxAmount($taxCalculatedAfterDiscount)
                ->setTaxAmount($taxCalculatedAfterDiscount);

            if($item->getQtyInvoiced() == $qty) {
                $item->setBaseTaxInvoiced($taxCalculatedAfterDiscount)
                    ->setTaxInvoiced($taxCalculatedAfterDiscount);
            } elseif($item->getQtyInvoiced() != 0) {
                echo PHP_EOL . "QTY INVOICED != 0 AND NOT EQUAL TO ORDERED XO";
                die('<br/>' . __METHOD__ . '1');
            }

            $rowTotal = $allQtyPrice;
            $discountTaxCompensationAmount = $allQtyOriginalPrice - $taxCalculatedAfterDiscount - $rowTotal;

            $item->setBaseRowTotal($rowTotal)
                ->setRowTotal($rowTotal);
            $item->setBaseDiscountTaxCompensationAmount($discountTaxCompensationAmount)
                ->setDiscountTaxCompensationAmount($discountTaxCompensationAmount);

            if($item->getQtyInvoiced() == $qty) {
                $item->setBaseRowInvoiced($rowTotal)
                    ->setRowInvoiced($rowTotal);
                $item->setBaseDiscountTaxCompensationInvoiced($discountTaxCompensationAmount)
                    ->setDiscountTaxCompensationInvoiced($discountTaxCompensationAmount);
            } elseif($item->getQtyInvoiced() != 0) {
                echo PHP_EOL . "QTY INVOICED != 0 AND NOT EQUAL TO ORDERED XO";
                die('<br/>' . __METHOD__ . '1');
            }

            $item->save();
            $itemTaxesTotal += $taxCalculatedAfterDiscount;
            $itemOriginalPriceTotal += $allQtyOriginalPrice;
            $rowTotalTotal += $rowTotal;
            $itemsUpdated = true;
        } catch (\Exception $e) {
            die($e->getMessage());
        }

    }

    echo PHP_EOL;
    echo PHP_EOL . "CONTROLLI FINALI: ";
    echo PHP_EOL . "ITEM ORIGINAL PRICE TOTAL: " . $itemOriginalPriceTotal;
    echo PHP_EOL . "ORDER TAX PERCENT: " . $orderTaxPercent;
    echo PHP_EOL . "ORDER TAX AMOUNT: " . $orderTaxAmount = $order->getTaxAmount();
    echo PHP_EOL . "ORDER DISCOUNT AMOUNT: " . $orderDiscountAmount = abs($order->getDiscountAmount());
    echo PHP_EOL . "ORDER DISCOUNT AMOUNT: " . $orderSubtotal = $order->getSubtotal();

    $itemOriginalPriceTotalCalculatedTax = number_format(number_format(((($itemOriginalPriceTotal-$orderDiscountAmount) * $orderTaxPercent)/($orderTaxPercent + 100)), 2), 4);
    if(((int)abs($itemTaxesTotal-$itemOriginalPriceTotalCalculatedTax)) > 0.01) {
        echo PHP_EOL . "ERRORE DURANTE IL CALCOLO DELLA SOMMA DELLE TASSE DEI PRODOTTI CON LE TASSE DEL SUBTOTALE";
        echo PHP_EOL . "SOMMA TASSE PRODOTTI: " . $itemTaxesTotal;
        echo PHP_EOL . "TASSE DA ORIGINAL PRICE: " . $itemOriginalPriceTotalCalculatedTax;
        die('<br/>' . __METHOD__ . '1');
    }

    if($itemTaxesTotal > $orderTaxAmount) {
        echo PHP_EOL . "ERRORE: LE TASSE DEI PRODOTTI SONO MAGGIORI DELLA TASSE DELL'ORDINE.";
        $productTaxesBiggerThanOrderTaxes[] = $incrementId;
    }

    if((int)abs($rowTotalTotal - $orderSubtotal) > 0.02) {
        echo PHP_EOL . "SOMMA DEL SUBTOTALE DEI PRODOTTI: " . $rowTotalTotal;
        echo PHP_EOL . "SUBTOTALE DELL'ORDINE: " . $orderSubtotal;
        echo PHP_EOL . "ERRORE: SUBTOTAL DIVERSO DAL SUBTOTALE SOMMATO DEI PRODOTTI";
        die('<br/>' . __METHOD__ . '1');
    }

    if($itemsUpdated) {
        echo PHP_EOL . PHP_EOL . "AGGIORNAMENTO EFFETTUATO CORRETTAMENTE";
        continue;
    }

    echo PHP_EOL . "TUTTO ERA GIA OK. SKIPPED";

}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
echo PHP_EOL . "<pre>";
print_r($productTaxesBiggerThanOrderTaxes);
echo "</pre>" . PHP_EOL;
