<?php

/**
 * Description of taxes-fix-calculation-for-discount
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
            ->addAttributeToSelect('*')
            ->addAttributeToFilter('discount_amount', ['neq' => 'NULL']);

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
foreach($ordersCollection as $order) {
    $shippingAddress = $order->getShippingAddress();
    $country = $shippingAddress->getCountryId();
    if($country != 'IT') {
        //Aggiungo controllo per IT
        continue;
    }

    $totalPaid = $order->getTotalPaid();
    if(empty($totalPaid) || ($totalPaid == 0) || ($totalPaid == NULL)) {
        $totalPaid = $order->getGrandTotal();
    }

    $currentTaxValue = $order->getTaxAmount();
    $rightTaxValue = number_format($totalPaid - ($totalPaid/1.22), 4);

    if($currentTaxValue != $rightTaxValue) {
        echo PHP_EOL . "ORDER: " . $incrementId = $order->getIncrementId();
        echo " - TOTAL PAID: " . $totalPaid;
        echo " - CURRENT TAX VALUE: " . $currentTaxValue;
        echo " - RIGHT TAX VALUE: " . $rightTaxValue;

//        try {
//            $order->setBaseTaxAmount($rightTaxValue)
//                ->setTaxAmount($rightTaxValue)
//                ->save();
//            $changeCounter++;
//        } catch (\Exception $e) {
//            echo PHP_EOL . "CANNOT SAVE ORDER: " . $incrementId . ' - ' . $e->getMessage();
//        }
    }
}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
