<?php
//VARIABLES
$user = 'drop';
$password = '6C8RbG9VumMX';
$websiteUrl = 'https://www.doppelganger.it/';
$orderId = 1784;

// RETRIEVE TOKEN
$userData = array("username" => $user, "password" => $password);
$tokenHeaders = array(
    "Content-Type: application/json",
    "Content-Length: " . strlen(json_encode($userData))
);
$token = makeCurlCall("POST", $tokenHeaders, $websiteUrl . 'rest/V1/integration/admin/token', $userData);
if(empty($token)) {
    echo PHP_EOL. "<pre>";
    print_r($token);
    echo "</pre>" . PHP_EOL;
    die(PHP_EOL . 'Empty Token');
}
echo PHP_EOL . "TOKEN: " . $token;

//RETRIEVE ORDER ITEM IDS
$requestHeaders = array(
    "Content-Type: application/json",
    "Authorization: Bearer " . json_decode($token)
);
$result = json_decode(makeCurlCall("GET", $requestHeaders, $websiteUrl . "rest/V1/orders/{$orderId}"));
if(empty($result)) {
    echo PHP_EOL. "<pre>";
    print_r($result);
    echo "</pre>" . PHP_EOL;
    die(PHP_EOL . 'Empty Order data');
}

//CREATE SHIPMENT
$shipData = ['entity' => ["orderId" => $orderId]];
foreach($result->items as $item) {
    $shipData['entity']['items'][] = [
        "extension_attributes" => '',
        "order_item_id" => $item->item_id,
        "qty" => $item->qty_invoiced
    ];
}
if(empty($shipData['entity']['items'])) {
    die(PHP_EOL . 'Empty Order items');
}

$requestHeaders = array(
    "Content-Type: application/json",
    "Authorization: Bearer " . json_decode($token)
);
$result = json_decode(makeCurlCall("POST", $requestHeaders, $websiteUrl . "rest/V1/order/{$orderId}/ship", $shipData));
if(is_array($result)) {
    echo PHP_EOL. "<pre>";
    print_r($result);
    echo "</pre>" . PHP_EOL;
} else {
    echo PHP_EOL . "SHIPMENT ID: " . $result;
}




function makeCurlCall($request = "POST", $requestHeaders, $url, array $postFields = null) {
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $request);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $requestHeaders);
    if(!empty($postFields)) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postFields));
    }

    $result = curl_exec($curl);
    $resultCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    if($resultCode != 200) {
        echo PHP_EOL . "ERROR RESPONSE CODE:" . $resultCode;
    }
    if (curl_error($curl)) {
        echo PHP_EOL . "ERROR MESSAGE:" . curl_error($curl);
    }

    curl_close($curl);
    return $result;
}
