<?php
ini_set("memory_limit","-1");
date_default_timezone_set('Europe/Rome');
require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');
$directory = $objectManager->get('\Magento\Framework\Filesystem\DirectoryList');
$invoiceFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory');

// Template id fattura
// **controllare a backend se corrisponde**
$templateId = 4;
// Prefix file
$prefix = 'export_2019';
// Data inizio
$dateFrom = date("Y-m-d", strtotime("01.01.2019"));
// Data fine
$dateTo = date("Y-m-d", strtotime("31.12.2019"));

$invoicesCollection = $invoiceFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('created_at', ['from' => $dateFrom])
    ->addAttributeToFilter('created_at', ['to' => $dateTo])
    //->addAttributeToFilter('fe_increment_id', ['neq' => NULL]);
    ->addAttributeToFilter('fe_increment_id', array('null' => true), 'left');

echo PHP_EOL . "INVOICE COUNT: " . $invoicesCollection->count();
echo PHP_EOL . "START";
sleep(2);
foreach ($invoicesCollection as $invoice) {
    $invoiceId = $invoice->getId();

    try {
        $eadesign = $objectManager->get('Drop\Pdfgenerator\Controller\Adminhtml\Order\Invoice\Printpdf');
        $eadesign->execute($templateId, $invoiceId, $prefix);
    } catch (Exception $e) {
        echo $e->getMessage();
    }
}
echo PHP_EOL."END";
echo PHP_EOL."File salvati su /src/var/";
