<?php
header( 'Content-Type: text/plain' );
header( 'Cache-Control: max-age=0' );

// Cross Site Script  & Code Injection Sanitization
function xss_cleaner($input_str) {
    $return_str = str_replace( array('<',';','|','&','>',"'",'"',')','('), array('&lt;','&#58;','&#124;','&#38;','&gt;','&apos;','&#x22;','&#x29;','&#x28;'), $input_str );
    $return_str = str_ireplace( '%3Cscript', '', $return_str );
    return $return_str;
}

function give_host($host_with_subdomain) {
    $array = explode(".", $host_with_subdomain);
    return (array_key_exists(count($array) - 2, $array) ? $array[count($array) - 2] : "").".".$array[count($array) - 1];
}

function purgeURL( $hostname, $ip_address, $purgeURL )
{
    $header = [
        "Host: www." . $hostname, // IMPORTANT
        "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8",
        "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.3",
        "Accept-Encoding: gzip,deflate,sdch",
        "Accept-Language: it-IT,it;q=0.8,en-US;q=0.6,en;q=0.4",
        "Cache-Control: max-age=0",
        "Connection: keep-alive"
    ];

    $curlOptionList = array(
        CURLOPT_URL                     => 'http://' . $ip_address . $purgeURL,
        CURLOPT_HTTPHEADER              => $header,
        CURLOPT_CUSTOMREQUEST           => "PURGE",
        CURLOPT_VERBOSE                 => true,
        CURLOPT_RETURNTRANSFER          => true,
        CURLOPT_NOBODY                  => true,
        CURLOPT_CONNECTTIMEOUT_MS       => 2000,
    );

    $fd = fopen("php://output", 'w+');
    $curlOptionList[CURLOPT_VERBOSE] = true;
    $curlOptionList[CURLOPT_STDERR]  = $fd;

    $curlHandler = curl_init();
    curl_setopt_array( $curlHandler, $curlOptionList );
    curl_exec( $curlHandler );
    curl_close( $curlHandler );
    if( $fd !== false ) {
        fclose( $fd );
    }
}

if((php_sapi_name() == 'cli')) {
    if(!empty($argv[1])) { $complete_url = $argv[1]; }
    else { echo PHP_EOL . "Missing first param url"; exit; }
} else {
    if(!empty($_POST['url'])) { $complete_url = $_POST['url']; }
    elseif(!empty($_GET['url'])) { $complete_url = $_GET['url']; }
    else { echo "<br/>" . "Missing url param"; exit; }
}

if(!empty($complete_url)) {
    $url_purge = parse_url($complete_url)['path'];
    $domain_purge = give_host(parse_url($complete_url)['host']);

    $varnish_ip = array("127.0.0.1");

    $URL      = xss_cleaner($url_purge);
    $host_name = xss_cleaner($domain_purge);

    foreach ($varnish_ip as &$ipaddress) {
        purgeURL( $host_name, $ipaddress, $URL );
    }
}
