<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$subscribersFactory = $objectManager->get('\Magento\Newsletter\Model\ResourceModel\Subscriber\CollectionFactory');
$customerRepositoryInterface = $objectManager->get('\Magento\Customer\Api\CustomerRepositoryInterface');

$subscribersCollection = $subscribersFactory->create();
echo PHP_EOL . "ROW COUNT: " . $subscribersCollection->count();

$syncCounter = 0;
foreach($subscribersCollection as $subscriber) {
    $customerId = $subscriber->getCustomerId();
    if(empty($customerId)) {
        continue;
    }

    try {
        $customer = $customerRepositoryInterface->getById($customerId);
    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        echo PHP_EOL . "DELETE SubscriberId {$subscriber->getSubscriberId()} WITH CustomerId: {$customerId}";
        deleteSubscriber($subscriber);
        continue;
    }
    
    $subscriberIsProfilingAccepted = $subscriber->getIsProfilingAccepted();
    $subscriberFirstName = $subscriber->getSubscriberFirstname();
    $subscriberLastname = $subscriber->getSubscriberLastname();
    $subscriberDob = $subscriber->getSubscriberDob();
    $subscriberGender = $subscriber->getSubscriberGender();

    $customerIsProfilingAccepted = '';
    if($customer->getCustomAttribute('is_profiling_accepted')) {
        $customerIsProfilingAccepted = $customer->getCustomAttribute('is_profiling_accepted')->getValue();
    }
    $customerFirstName = $customer->getFirstname();
    $customerLastname = $customer->getLastname();
    $customerDob = $customer->getDob();
    $customerGender = $customer->getGender();
    
    $isChanged = false;
    if(!empty($customerIsProfilingAccepted) && ($subscriberIsProfilingAccepted != $customerIsProfilingAccepted)) {
        $isChanged = true;
        $subscriber->setIsProfilingAccepted($customerIsProfilingAccepted);
        echo PHP_EOL . "getIsProfilingAccepted " . $subscriberIsProfilingAccepted;
        echo PHP_EOL . "setIsProfilingAccepted " . $customerIsProfilingAccepted;
    }
    if(!empty($customerFirstName) && ($subscriberFirstName != $customerFirstName)) {
        $isChanged = true;
        $subscriber->setSubscriberFirstname($customerFirstName);
        echo PHP_EOL . "getSubscriberFirstname " . $subscriberFirstName;
        echo PHP_EOL . "setSubscriberFirstname " . $customerFirstName;
    }
    if(!empty($customerLastname) && ($subscriberLastname != $customerLastname)) {
        $isChanged = true;
        $subscriber->setSubscriberLastname($customerLastname);
        echo PHP_EOL . "getSubscriberLastname " . $subscriberLastname;
        echo PHP_EOL . "setSubscriberLastname " . $customerLastname;
    }
    if((empty($subscriberDob) && !empty($customerDob))) {
        $isChanged = true;
        $explodedDob = explode('-', $customerDob);
        $convertedDate = $explodedDob[2] . '/' . $explodedDob[1] . '/' . $explodedDob[0];
        $subscriber->setSubscriberDob($convertedDate);
        echo PHP_EOL . "getSubscriberDob " . $subscriberDob;
        echo PHP_EOL . "setSubscriberDob " . $convertedDate . ' (' . $customerDob . ')';
    }
    if(!empty($customerGender) && ($subscriberGender != $customerGender)) {
        $isChanged = true;
        $subscriber->setSubscriberGender($customerGender);
        echo PHP_EOL . "getSubscriberGender " . $subscriberGender;
        echo PHP_EOL . "setSubscriberGender " . $customerGender;
    }

    if(!$isChanged) {
        continue;
    }

    try {
        echo PHP_EOL . "SYNC SubscriberId {$subscriber->getSubscriberId()} WITH CustomerId: {$customerId}";
        $subscriber->save();
        $syncCounter++;
    } catch (\Exception $e) {
        echo PHP_EOL . "" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }
}

echo PHP_EOL . "SYNC TOTAL COUNTER: " . $syncCounter;

function deleteSubscriber($subscriber) {
    try {
        echo PHP_EOL . "DELETE SUBSCRIBER {$subscriber->getSubscriberId()}";
        $subscriber->delete();
    } catch (Exception $e) {
        echo "<br/>" . $e->getMessage();
        die('<br/>' . __METHOD__ . '1');
    }
}
