<?php

/**
 * Description of products update stores special prices
 * @date 22-jul-2021 10.57.45
 * @author Gianluca Mariani <g.mariani@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$storeManager = $objectManager->get('Magento\Store\Model\StoreManagerInterface');
$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\CollectionFactory');
$productResourceModel = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product');
$productRepository = $objectManager->create('Magento\Catalog\Api\ProductRepositoryInterface');
$productFactory = $objectManager->create('\Magento\Catalog\Model\ProductFactory');
$csv = $objectManager->create('Magento\Framework\File\Csv');
$file = $objectManager->create('Magento\Framework\Filesystem\Driver\File');
$fileSystem = $objectManager->create('\Magento\Framework\Filesystem');
$mediaPath = $fileSystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)->getAbsolutePath();

$app_state = $objectManager->get('\Magento\Framework\App\State');
$app_state->setAreaCode('adminhtml');

$csvFile = $mediaPath . '/import/prices_conf_special.csv';
try {
    if ($file->isExists($csvFile)) {
        //set delimiter, for tab pass "\t"
        $csv->setDelimiter(",");
        //get data as an array
        $products = $csv->getData($csvFile);
    } else {
        echo 'Csv file not exist' . PHP_EOL;
        die();
    }
} catch (FileSystemException $e) {
    echo $e->getMessage();
    die();
}

//store view IDs
$stores = [8, 9, 10];

if (!empty($products)) {
    // ignore first header column and read data
    foreach (array_slice($products, 1) as $key => $value) {
        $sku = trim($value['0']);
        $price = trim($value['1']);
        try {
            $productObj = $productRepository->get($sku);
        } catch (Exception $e) {
            echo $sku . " - " . $e->getMessage() . PHP_EOL;
            continue;
        }
        if ($productObj && $productObj->getTypeId() === 'configurable') {
            try {
                $simpleCollection = $productCollection->create()
                    ->addAttributeToSelect('*')
                    ->addAttributeToFilter('sku', ['like' => $sku . '%'])
                    ->addAttributeToFilter('type_id', ['eq' => \Magento\Catalog\Model\Product\Type::TYPE_SIMPLE])
                    ->setFlag('has_stock_status_filter', false);

                foreach ($simpleCollection as $simple) {
                    foreach ($stores as $store) {
                        $product = $productFactory->create();
                        $productResourceModel->load($product, $simple->getId());
                        $product->setStoreId($store);
                        $storeCode = $storeManager->getStore($store)->getCode();
                        if (isset($argv[1])) {
                            if ($argv[1] == "clean") {
                                $product->setSpecialPrice(null);
                                $product->setSpecialFromDate(null);
                                $product->setSpecialToDate(null);
                                $product->reloadPriceInfo();
                                $productResourceModel->saveAttribute($product, 'special_price');
                                $productResourceModel->saveAttribute($product, 'special_from_date');
                                $productResourceModel->saveAttribute($product, 'special_to_date');
                                echo $product->getSku() . " special price rimosso per lo store " . $storeCode . PHP_EOL;
                            }
                        } else {
                            $product->setSpecialPrice($price);
                            $product->reloadPriceInfo();
                            $productResourceModel->saveAttribute($product, 'special_price');
                            echo $product->getSku() . " special price modificato per lo store " . $storeCode . PHP_EOL;
                        }
                    }
                }
            } catch (Exception $e) {
                echo $e->getMessage();
            }
        }
    }
}
echo PHP_EOL . "FINE" . PHP_EOL;
