<?php

/**
 * Description of products update stores simple prices
 * @date 21-jul-2021 14.23.01
 * @author Gianluca Mariani <g.mariani@drop.it>
 */

require_once(__DIR__ . '/../bootstrap.php');

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$storeManager = $objectManager->get('Magento\Store\Model\StoreManagerInterface');
$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\CollectionFactory');
$productResourceModel = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product');
$productRepository = $objectManager->create('Magento\Catalog\Api\ProductRepositoryInterface');
$productFactory = $objectManager->create('\Magento\Catalog\Model\ProductFactory');
$csv = $objectManager->create('Magento\Framework\File\Csv');
$file = $objectManager->create('Magento\Framework\Filesystem\Driver\File');
$fileSystem = $objectManager->create('\Magento\Framework\Filesystem');
$mediaPath = $fileSystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)->getAbsolutePath();

$app_state = $objectManager->get('\Magento\Framework\App\State');
$app_state->setAreaCode('adminhtml');

$csvFile = $mediaPath . '/import/prices_simple.csv';
try {
    if ($file->isExists($csvFile)) {
        //set delimiter, for tab pass "\t"
        $csv->setDelimiter(",");
        //get data as an array
        $products = $csv->getData($csvFile);
    } else {
        echo 'Csv file not exist' . PHP_EOL;
        die();
    }
} catch (FileSystemException $e) {
    echo $e->getMessage();
    die();
}

//store view IDs
$stores = [8, 9, 10];

if (!empty($products)) {
    // ignore first header column and read data
    foreach (array_slice($products, 1) as $key => $value) {
        $sku = trim($value['0']);
        $price = trim($value['1']);
        try {
            $productObj = $productRepository->get($sku);
        } catch (Exception $e) {
            echo $sku . " - " . $e->getMessage() . PHP_EOL;
            continue;
        }
        if ($productObj && $productObj->getTypeId() == 'simple') {
            try {
                foreach ($stores as $store) {
                    $product = $productFactory->create();
                    $productResourceModel->load($product, $productObj->getId());
                    $product->setStoreId($store);
                    $product->setPrice($price);
                    $productResourceModel->saveAttribute($product, 'price');
                    $storeCode = $storeManager->getStore($store)->getCode();
                    echo $product->getSku() . " prezzo modificato per lo store " . $storeCode . PHP_EOL;
                }
            } catch (Exception $e) {
                echo $e->getMessage();
            }
        } else {
            echo $sku . " non è un prodotto semplice". PHP_EOL;
        }
    }
}
echo PHP_EOL . "FINE" . PHP_EOL;
