<?php

/**
 * Description of products simple enable
 * @date 20-jul-2021 11.26.12
 * @author Gianluca Mariani <g.mariani@drop.it>
 */
require_once(__DIR__ . '/../bootstrap.php');

$objectManager = \Magento\Framework\App\ObjectManager::getInstance();

$productCollection = $objectManager->create('Magento\Catalog\Model\ResourceModel\Product\CollectionFactory');
$productRepository = $objectManager->create('Magento\Catalog\Api\ProductRepositoryInterface');
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

$skus = ["sku1", "sku2", "sku3"];

foreach ($skus as $sku) {
    $productObj = $productRepository->get($sku);
    if ($productObj && $productObj->getTypeId() === 'configurable') {
        try {
            $simpleCollection = $productCollection->create()
                ->addAttributeToSelect('*')
                ->addAttributeToFilter('sku', ['like' => $sku . '%'])
                ->addAttributeToFilter('type_id', ['eq' => \Magento\Catalog\Model\Product\Type::TYPE_SIMPLE])
                ->setFlag('has_stock_status_filter', false);

            foreach ($simpleCollection as $simple) {
                $simpleProduct = $productRepository->get($simple->getSku());
                $simpleProduct->setStatus(\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED);
                $productRepository->save($simpleProduct);
                echo $simpleProduct->getSku() . " abilitato" . PHP_EOL;
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    } else {
        echo "ERRORE - SKU " . $sku . " ERRATO?" . PHP_EOL;
    }
}
