<?php

/**
 * Description of products assign website
 * @date 30-dec-2020 11.02.10
 * @author Gianluca Mariani <g.mariani@drop.it>
 */
require_once(__DIR__ . '/../bootstrap.php');

$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

// website id da aggiungere ai prodotti
$idWebsite = [4];
die("COMMENTARE IL DIE DOPO AVER AGGIORNATO L'ID WEBSITE, POI RILANCIARE");

$collectionFactory = $objectManager->create(\Magento\Catalog\Model\ResourceModel\Product\CollectionFactory::class);
$collection = $collectionFactory->create()->addAttributeToSelect('*')->setFlag('has_stock_status_filter', false);
$productActionObject = $objectManager->create('Magento\Catalog\Model\Product\Action');

//echo count($collection).PHP_EOL;

$collection->setPageSize(50);
$pages = $collection->getLastPageNumber();
for ($pageNum = 1; $pageNum <= $pages; $pageNum++) {
    $collection->setCurPage($pageNum);
    foreach ($collection as $item) {
        try {
            $sku = $item->getSku();
            if (!array_diff($idWebsite, $item->getWebsiteIds())) {
                echo "STOP - website già presente sul prodotto " . $sku . PHP_EOL;
                continue;
            }
            $productActionObject->updateWebsites([$item->getId()], $idWebsite, 'add');
            echo "OK - website aggiunto al prodotto " . $sku . PHP_EOL;
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }
    $collection->clear();
}

echo PHP_EOL."FINE".PHP_EOL;
