<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$ordersFactory = $objectManager->get('Magento\Sales\Model\ResourceModel\Order\CollectionFactory');

$ordersCollection = $ordersFactory->create()
    ->addAttributeToSelect('*')
    ->addAttributeToFilter('total_due', ['neq' => 0]);

echo PHP_EOL . "ROW COUNT: " . $ordersCollection->count();

$changeCounter = 0;
foreach($ordersCollection as $order) {
    $incrementId = $order->getIncrementId();
    $totalDue = $order->getTotalDue();
    $totalDueExclTax = number_format(($totalDue/1.22),4);
    $grandTotal = $order->getGrandTotal();
    $totalPaid = $order->getTotalPaid();
    $totalPaidExclTax = number_format(($totalPaid/1.22),4);
    $discountAmount = $order->getDiscountAmount();
    $discountAmountExclTax = number_format(($discountAmount/1.22),4);
    $shippingAmount = $order->getShippingAmount();
    $subtotal = $order->getSubtotal();
    $subtotalInclTax = $order->getSubtotalInclTax();
    $taxAmount = $order->getTaxAmount();
    $cod = $order->getMspCodAmount();

    if(($totalPaid == 0) || ($totalPaid == NULL) || empty($totalPaid)) {
        continue;
    }

    //Se sono uguali per questo script è ok
    if(($totalPaid == $grandTotal) && ($totalDue == 0)) {
        continue;
    }

    echo PHP_EOL . "--------------------------------------";

    echo PHP_EOL . "INCREMENT: " . $incrementId;
    echo PHP_EOL;
    echo PHP_EOL . 'VALORI ORIGINALI:';
    echo PHP_EOL . "SUBTOTAL: " . $subtotal;
    echo PHP_EOL . "SHIPPING AMOUNT: " . $shippingAmount;
    echo PHP_EOL . "DISCOUNT AMOUNT: " . $discountAmount;
    echo PHP_EOL . "COD AMOUNT: " . $cod;
    echo PHP_EOL . "TAX AMOUNT: " . $taxAmount;
    echo PHP_EOL . "GRAND_TOTAL: " . $grandTotal;
    echo PHP_EOL . "TOTAL PAID: " . $totalPaid;
    echo PHP_EOL . "TOTAL_DUE: " . $totalDue;


    $calculatedTaxAmount = number_format(number_format(($totalPaid - $totalPaidExclTax), 2), 4);

    $overrideTax = false;
    if($taxAmount != $calculatedTaxAmount) {
        $overrideTax = true;
    }

    $overrideForTooBigTotalDue = false;
    $remainingCosts = 0;
    if($totalDueExclTax < $shippingAmount) {
        $remainingCosts = $totalPaid - $calculatedTaxAmount  - $subtotal - $discountAmountExclTax - $cod;
    } else {
        $overrideCod = true;
        $overrideShipping = true;
        $overrideForTooBigTotalDue = true;
        $calculatedShippingAmount = 0;
        $calculatedShippingTaxAmount = 0;
        $calculatedCodAmount = number_format(number_format(($cod - ($totalDueExclTax - $shippingAmount)), 2), 4);
        $calculatedCodTaxAmount = number_format(($calculatedCodAmount - ($calculatedCodAmount/1.22)), 4);

        if($calculatedCodAmount < 0) {
            echo PHP_EOL;
            echo PHP_EOL . "DEBUG CALCULATE COD: ";
            echo PHP_EOL . "COD AMOUNT: " . $cod;
            echo PHP_EOL . "TOTAL DUE: " . $totalDueExclTax;
            echo PHP_EOL . "SHIPPING AMOUNT: " . $shippingAmount;
            die(PHP_EOL . 'ERROR: Cod costs < 0. Cannot sub');
        }
    }

    if(!$overrideForTooBigTotalDue) {
        $subFromCurrentCost = false;
        if($remainingCosts < 0) {

            echo PHP_EOL . 'ERROR: Remaining costs < 0: ' . $remainingCosts;
            $overrideShipping = false;
            $overrideCod = false;
            $subFromCurrentCost = true;
            if($shippingAmount > 0) {
                if($shippingAmount >= abs($remainingCosts)) {
                    $overrideShipping = true;
                    $calculatedShippingAmount = $shippingAmount - abs($remainingCosts);
                    $calculatedShippingTaxAmount = number_format(($calculatedShippingAmount - ($calculatedShippingAmount/1.22)), 4);

                    if($calculatedShippingAmount<0) {
                        die(PHP_EOL . 'ERROR: Shipping costs < 0. Cannot sub');
                    }
                } else {
                    if($cod > 0) {
                        $overrideCod = true;
                        $overrideShipping = true;
                        $calculatedCodAmount = $cod - (abs($remainingCosts) - $shippingAmount);
                        $calculatedCodTaxAmount = number_format(($calculatedCodAmount - ($calculatedCodAmount/1.22)), 4);
                        $calculatedShippingAmount = 0;
                        $calculatedShippingTaxAmount = 0;

                        if($calculatedCodAmount < 0) {
                            die(PHP_EOL . 'ERROR: Cod costs < 0. Cannot sub');
                        }
                    } else {
                        die(PHP_EOL. 'ERROR: NON HO MODO DI RICALCOLARE. E TUTTO A ZERO.');
                    }
                }
            } elseif($cod > 0) {
                $overrideCod = true;
                $calculatedCodAmount = $cod - abs($remainingCosts);
                $calculatedCodTaxAmount = number_format(($calculatedCodAmount - ($calculatedCodAmount/1.22)), 4);

                if($calculatedCodAmount < 0) {
                    die(PHP_EOL . 'ERROR: Cod costs < 0. Cannot sub');
                }
            } else {
                echo PHP_EOL;
                echo PHP_EOL . "DEBUG REMAININ COSTS: ";
                echo PHP_EOL . "TOTAL PAID: " . $totalPaid;
                echo PHP_EOL . "CALCULATED TAX AMOUNT: " . $calculatedTaxAmount;
                echo PHP_EOL . "SUBTOTAL: " . $subtotal;
                echo PHP_EOL . "DISCOUNT AMOUNT EXCL TAX: " . $discountAmountExclTax;
                echo PHP_EOL . "COD AMOUNT: " . $cod;
                die(PHP_EOL. 'ERROR: NON HO MODO DI RICALCOLARE. E TUTTO A ZERO.');
            }
        }
    }

    if(!$overrideForTooBigTotalDue && !$subFromCurrentCost) {
        $overrideShipping = false;
        $overrideCod = false;
        if($remainingCosts <= $shippingAmount) {
            //Setto sulla spedizione i costi rimanenti sistemando
            $overrideShipping = true;
            $calculatedShippingAmount = $remainingCosts;
            $calculatedShippingTaxAmount = number_format(($calculatedShippingAmount - ($calculatedShippingAmount/1.22)), 4);

            if($calculatedShippingAmount<0) {
                die(PHP_EOL . 'ERROR: Shipping costs < 0');
            }
        } else {
            //Setto sulla spedizione e sul cash on delivery
            $overrideCod = true;
            $overrideShipping = true;
            $calculatedCodAmount = $cod - ($remainingCosts - $shippingAmount);
            $calculatedCodTaxAmount = number_format(($calculatedCodAmount - ($calculatedCodAmount/1.22)), 4);
            $calculatedShippingAmount = 0;
            $calculatedShippingTaxAmount = 0;

            if($calculatedCodAmount < 0) {
                die(PHP_EOL . 'ERROR: Cod costs < 0');
            }
        }
    }

    echo PHP_EOL;
    echo PHP_EOL . "RESOCONTO RICALCOLO: ";
    echo PHP_EOL . "SUBTOTAL: " . $subtotal;

    if($overrideShipping) {
        echo PHP_EOL . 'CALCULATED SHIPPING AMOUNT: ' . $calculatedShippingAmount . ' (+ tax: ' . $calculatedShippingTaxAmount . ')';
    } else {
        $calculatedShippingAmount = $shippingAmount;
        echo PHP_EOL . 'SHIPPING AMOUNT: ' . $shippingAmount;
    }

    echo PHP_EOL . "DISCOUNT: " . $discountAmount . ' (tax excl: ' . $discountAmountExclTax . ')';

    if($overrideCod) {
        echo PHP_EOL . 'CALCULATED COD AMOUNT: ' . $calculatedCodAmount . ' (+ tax: ' . $calculatedCodTaxAmount . ')';
    } else {
        $calculatedCodAmount = $cod;
        echo PHP_EOL . 'COD AMOUNT: ' . $cod;
    }

    if($overrideTax) {
        echo PHP_EOL . 'CALCULATED TAX AMOUNT: ' . $calculatedTaxAmount;
    } else {
        $calculatedTaxAmount = $taxAmount;
        echo PHP_EOL . 'TAX AMOUNT: ' . $taxAmount;
    }

    echo PHP_EOL . "CALCULATED GRAND TOTAL (TOTAL PAID): " . $totalPaid;

    $isRightCalculated =  number_format(($subtotal + $calculatedShippingAmount + $calculatedCodAmount + $calculatedTaxAmount + $discountAmountExclTax),4);
    if(abs($isRightCalculated - $totalPaid) < 0.1) {
        echo PHP_EOL;
        echo PHP_EOL . "*** TUTTO CORRETTO ***";
    } else {
        echo PHP_EOL . "+++ ERRORE NEL RICALCOLO +++ : " . $isRightCalculated;
        die(PHP_EOL);
    }

    $invoice = $order->getInvoiceCollection()->getFirstItem();
    $credimemo = $order->getCreditmemosCollection()->getFirstItem();

//    try {
//        $saveInvoice = false;
//        $saveCreditmemo = false;
//
//        if($overrideTax) {
//            $order->setBaseTaxAmount($calculatedTaxAmount);
//            $order->setTaxAmount($calculatedTaxAmount);
//            if(is_object($invoice) && !empty($invoice->getData())) {
//                $saveInvoice = true;
//                $invoice->setBaseTaxAmount($calculatedTaxAmount);
//                $invoice->setTaxAmount($calculatedTaxAmount);
//            }
//            if(is_object($credimemo) && !empty($credimemo->getData())) {
//                $saveCreditmemo = true;
//                $credimemo->setBaseTaxAmount($calculatedTaxAmount);
//                $credimemo->setTaxAmount($calculatedTaxAmount);
//            }
//        }
//
//        if($overrideShipping) {
//            $order->setBaseShippingAmount($calculatedShippingAmount);
//            $order->setShippingAmount($calculatedShippingAmount);
//            $order->setBaseShippingTaxAmount($calculatedShippingTaxAmount);
//            $order->setShippingTaxAmount($calculatedShippingTaxAmount);
//            $order->setBaseShippingInclTax($calculatedShippingAmount + $calculatedShippingTaxAmount);
//            $order->setShippingInclTax($calculatedShippingAmount + $calculatedShippingTaxAmount);
//            if(is_object($invoice) && !empty($invoice->getData())) {
//                $saveInvoice = true;
//                $invoice->setBaseShippingAmount($calculatedShippingAmount);
//                $invoice->setShippingAmount($calculatedShippingAmount);
//                $invoice->setBaseShippingTaxAmount($calculatedShippingTaxAmount);
//                $invoice->setShippingTaxAmount($calculatedShippingTaxAmount);
//                $invoice->setBaseShippingInclTax($calculatedShippingAmount + $calculatedShippingTaxAmount);
//                $invoice->setShippingInclTax($calculatedShippingAmount + $calculatedShippingTaxAmount);
//            }
//            if(is_object($credimemo) && !empty($credimemo->getData())) {
//                $saveCreditmemo = true;
//                $credimemo->setBaseShippingAmount($calculatedShippingAmount);
//                $credimemo->setShippingAmount($calculatedShippingAmount);
//                $credimemo->setBaseShippingTaxAmount($calculatedShippingTaxAmount);
//                $credimemo->setShippingTaxAmount($calculatedShippingTaxAmount);
//                $credimemo->setBaseShippingInclTax($calculatedShippingAmount + $calculatedShippingTaxAmount);
//                $credimemo->setShippingInclTax($calculatedShippingAmount + $calculatedShippingTaxAmount);
//            }
//        }
//
//        if($overrideCod) {
//            $order->setBaseMspCodAmount($calculatedCodAmount);
//            $order->setMspCodAmount($calculatedCodAmount);
//            $order->setBaseMspCodTaxAmount($calculatedCodTaxAmount);
//            $order->setMspCodTaxAmount($calculatedCodTaxAmount);
//            if(is_object($invoice) && !empty($invoice->getData())) {
//                $saveInvoice = true;
//                $invoice->setBaseMspCodAmount($calculatedCodAmount);
//                $invoice->setMspCodAmount($calculatedCodAmount);
//                $invoice->setBaseMspCodTaxAmount($calculatedCodTaxAmount);
//                $invoice->setMspCodTaxAmount($calculatedCodTaxAmount);
//            }
//            if(is_object($credimemo) && !empty($credimemo->getData())) {
//                $saveCreditmemo = true;
//                $credimemo->setBaseMspCodAmount($calculatedCodAmount);
//                $credimemo->setMspCodAmount($calculatedCodAmount);
//                $credimemo->setBaseMspCodTaxAmount($calculatedCodTaxAmount);
//                $credimemo->setMspCodTaxAmount($calculatedCodTaxAmount);
//            }
//        }
//
//        $order->setBaseGrandTotal($totalPaid);
//        $order->setGrandTotal($totalPaid);
//        $order->setBaseTotalDue(0);
//        $order->setTotalDue(0);
//
//        $order->addStatusHistoryComment('FE');
//        $order->save();
//
//        if(is_object($invoice) && $saveInvoice && !empty($invoice->getData())) {
//            $invoice->addComment('FE');
//            $invoice->save();
//        }
//        if(is_object($credimemo) && $saveCreditmemo && !empty($credimemo->getData())) {
//            $credimemo->addComment('FE');
//            $credimemo->save();
//        }
//
//        $changeCounter++;
//    } catch (\Exception $e) {
//        echo PHP_EOL . "CANNOT SAVE ORDER: " . $incrementId . ' - ' . $e->getMessage();
//    }

}

echo PHP_EOL . "CHANGE TOTAL COUNTER: " . $changeCounter;
