<?php

require_once(__DIR__ . '/../bootstrap.php');

$objectManager = Magento\Framework\App\ObjectManager::getInstance();
$objectManager->get('Magento\Framework\Registry')->register('isSecureArea', true);
$addressFactory = $objectManager->get('Magento\Customer\Model\ResourceModel\Address\CollectionFactory');

$addressCollection = $addressFactory->create()
    ->addFieldToFilter('region_id', 0)
    ->addFieldToFilter('country_id', 'IT');

echo PHP_EOL . "ROW COUNT: " . $addressCollection->count();

if($addressCollection->count() == 0) {
    echo PHP_EOL . 'TUTTAPPOSHT' . PHP_EOL;
    exit();
}

$notUpdatedForException = [];
foreach($addressCollection as $address) {
    echo PHP_EOL . $addressString = getStoreFormattedAddress($address);
    if(empty($addressString)) {
        continue;
    }

    $response = geocode($addressString);
    if(empty($response)) {
        try {
            $address->delete();
        } catch (\Exception $e) {
            echo PHP_EOL . 'DELETE EXCEPTION: ' . $e->getMessage();
            $notUpdatedForException[] = [
                'ex' => $e->getMessage(),
                'address_id' => $address->getId()
            ];
        }
        continue;
    }

    echo PHP_EOL . '' . $geolocatedRegionCode = getRegionIdFromGoogleMapsResponse($response);
    if(empty($geolocatedRegionCode)) {
        try {
            $address->delete();
        } catch (\Exception $e) {
            echo PHP_EOL . 'DELETE EXCEPTION: ' . $e->getMessage();
            $notUpdatedForException[] = [
                'ex' => $e->getMessage(),
                'address_id' => $address->getId()
            ];
        }
        continue;
    }

    echo PHP_EOL . '' . $regionId = getMagentoRegionId($geolocatedRegionCode, $address->getCountryId());
    if(empty($regionId)) {
        try {
            $address->delete();
        } catch (\Exception $e) {
            echo PHP_EOL . 'DELETE EXCEPTION: ' . $e->getMessage();
            $notUpdatedForException[] = [
                'ex' => $e->getMessage(),
                'address_id' => $address->getId()
            ];
        }
        continue;
    }

    $address->setRegion('');
    $address->setRegionId($regionId);
    try {
        $address->save();
        echo PHP_EOL . 'UPDATED ADDRESS_ID: ' . $address->getId();
        echo PHP_EOL . '-------------------------------';
    } catch (\Exception $e) {
        echo PHP_EOL . 'SAVE EXCEPTION: ' . $e->getMessage();
        $notUpdatedForException[] = [
            'ex' => $e->getMessage(),
            'address_id' => $address->getId()
        ];
    }

}

if(count($notUpdatedForException)) {
    echo PHP_EOL . '$notUpdatedForException:';
    echo PHP_EOL . "<pre>";
    print_r($notUpdatedForException);
    echo "</pre>" . PHP_EOL;
    echo PHP_EOL . 'POSSIBILE?';
}
echo PHP_EOL;

/**
 * @param $address
 * @return array|bool|string
 */
function geocode($address) {
    $objectManager = Magento\Framework\App\ObjectManager::getInstance();
    $scopeConfig = $objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface');
    $googleMapsKey = $scopeConfig->getValue('limesharp_stockists/stockist_map/api_key');
    if(empty($googleMapsKey)) {
        die(PHP_EOL . 'Empty API KEY from Limesharp Stockist Module');
    }

    if(empty($address)) {
        echo PHP_EOL . '' . 'Empty address';
        return false;
    }

    try {
        $geocoder = new \GoogleMapsGeocoder($address);
        $geocoder->setApiKey($googleMapsKey);
        $response = $geocoder->geocode();

        if($response['status'] != "OK") {
            $errorMessage = $response['status'];
            if(!empty($response['error_message'])) {
                $errorMessage .= ' - ' . $response['error_message'];
            }
            echo PHP_EOL . '' . $errorMessage;
            return false;
        }

        return $response;
    } catch (\Exception $ex) {
        echo PHP_EOL . '' . $ex->getMessage();
    }
}

/**
 * @param $address
 * @return string
 */
function getStoreFormattedAddress($address) {
    $addressString = '';
    $addressString .= $address->getStreet()[0];
    if(!empty($address->getStreet()[1])) {
        $addressString .= ' ' . $address->getStreet()[1];
    }
    if(!empty($address->getPostcode())) {
        $addressString .=  ', ' . $address->getPostcode();
    }
    if(!empty($address->getCity())) {
        $addressString .=  ' ' . $address->getCity();
    }
    if(!empty($address->getRegion())) {
        $addressString .=  ' ' . $address->getRegion();
    }
    if(!empty($address->getCountryId())) {
        $addressString .=  ', ' . $address->getCountryId();
    } elseif(!empty($address->getCountry())) {
        $addressString .=  ', ' . $address->getCountry();
    }

    return $addressString;
}

/**
 * @param $response
 * @return string|bool
 */
function getRegionIdFromGoogleMapsResponse($response) {
    foreach($response['results'][0]['address_components'] as $addressComponent) {
        foreach($addressComponent['types'] as $type) {
            if($type == 'administrative_area_level_2') {
                return $addressComponent['short_name'];
            }
        }
    }
    return false;
}

/**
 * @param $regionCode
 * @param $countryId
 * @return int|bool
 */
function getMagentoRegionId($regionCode, $countryId) {
    $objectManager = Magento\Framework\App\ObjectManager::getInstance();
    $regionModel = $objectManager->create('Magento\Directory\Model\Region');
    $region = $regionModel->loadByCode($regionCode,$countryId);
    if($region && $region->getRegionId()) {
        return $region->getRegionId();
    }
    return false;
}
