<?php

/**
 * Description of View
 * @date 16-apr-2018 18.21.12
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

namespace Rcason\MqGui\Block\Adminhtml\Mq\View;

class Actions extends \Magento\Backend\Block\Template {
    
    protected $urlBuilder;
    protected $_aclResource = "message_queue_execute";
    
    public function __construct(
            \Magento\Backend\Block\Template\Context $context,
            array $data = [],
            \Magento\Framework\UrlInterface $urlBuilder
    ) {
        parent::__construct($context, $data);
        $this->urlBuilder = $urlBuilder;
        $this->setTemplate('mq/view/actions.phtml');
    }
    
    public function isAllowed() {
        return $this->_authorization->isAllowed('Rcason_MqGui::' . $this->_aclResource);
    }    
    
    public function getBackUrl() {
        return $this->urlBuilder->getUrl("rcasonmqgui/mq/listing", array('entity_id' => $this->getRequest()->getParam("entity_id")));
    }
    public function getExecuteUrl() {
        return $this->urlBuilder->getUrl("rcasonmqgui/mq/execute", array('entity_id' => $this->getRequest()->getParam("entity_id")));
    }
    public function getDeleteUrl() {
        return $this->urlBuilder->getUrl("rcasonmqgui/mq/delete", array('entity_id' => $this->getRequest()->getParam("entity_id")));
    }
    
}