<?php

/**
 * Copyright © 2017 Magento. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace Rcason\MqGui\Ui\DataProvider;


/**
 * Task provider for the tasks listing
 * @version 1.0.0
 */
class MqProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{

    /**
     * @var \Rcason\MqGui\Model\ResourceModel\Task\Collection
     */
    protected $collection;

    /**
     * Class constructor
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param \Rcason\MqGui\Model\ResourceModel\Mq\CollectionFactory $collectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        \Rcason\MqGui\Model\ResourceModel\Mq\CollectionFactory $collectionFactory,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->collection = $collectionFactory->create();
    }

}
