<?php

namespace Rcason\MqGui\Controller\Adminhtml\Mq;

class View extends \Magento\Backend\App\Action
{

    protected $_aclResource = "message_queue_view";
    protected $resultPageFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
    }
    
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        
        $entityId = $this->getRequest()->getParam("entity_id");
        
        if(empty($entityId)) {
            $this->messageManager->addError(__('Can\'t find this job.'));
            return $resultRedirect->setPath('*/mq/listing');
        }
        
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Magento_Backend::system');
        $resultPage->addBreadcrumb(__('Message Queue'), __('Message Queue Detail'));
        $resultPage->getConfig()->getTitle()->prepend(__('Message Queue ID: ') . $entityId);
        return $resultPage;
        
    }

}
