<?php

/**
 * Description of View
 * @date 16-apr-2018 18.21.12
 * @author Cristiano Pieroni <c.pieroni@drop.it>
 */

namespace Rcason\MqGui\Block\Adminhtml\Mq;

use \Rcason\MqGui\Ui\Component\Mq\Column\Status\Options as Options;

class View extends \Magento\Backend\Block\Template {
    
    protected $jobFactory;
    protected $queueMessageRepository;
    protected $_messageManager;
    protected $resultRedirect;
    
    public function __construct(
            \Magento\Backend\Block\Template\Context $context,
            array $data = [],
            \Rcason\MqGui\Model\MqFactory $jobFactory,
            \Rcason\MqMysql\Api\QueueMessageRepositoryInterface $queueMessageRepository,
            \Magento\Framework\Message\ManagerInterface $messageManager,
            \Magento\Framework\Controller\ResultFactory $resultRedirect
    ) {
        parent::__construct($context, $data);
        $this->jobFactory = $jobFactory;
        $this->queueMessageRepository = $queueMessageRepository;
        $this->_messageManager = $messageManager;
        $this->resultRedirectFactory = $resultRedirect;
    }
    
    public function getMessage() {
        $entityId = $this->getRequest()->getParam("entity_id");
        $queueMessage = $this->queueMessageRepository->get($entityId);
        if(!$queueMessage) {
            $this->_messageManager->addError(__("Can't view {$entityId} message."));
            $resultRedirect = $this->resultRedirectFactory->create();
            return $resultRedirect->setPath('*/mq/listing');
        }
        return $queueMessage;
    }
    
    
    public function getStatusName($status) {
        $optionClass = new Options;
        $options = $optionClass->toOptionArray();
        $key = array_search($status, array_column($options, 'value'));
        if(is_null($key)) {
            return false;
        }
        return $options[$key]['label'];
    }     
    
}