<?php

namespace Rcason\MqGui\Controller\Adminhtml\Mq;

class Execute extends \Rcason\MqGui\Controller\Adminhtml\Mq
{

    protected $_aclResource = "message_queue_view";
    protected $queueMessageRepository;
    protected $consumer;
    protected $messageEnvelopeFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Rcason\MqMysql\Api\QueueMessageRepositoryInterface $queueMessageRepository,
        \Rcason\Mq\Api\Data\MessageEnvelopeInterfaceFactory $messageEnvelopeFactory,
        \Rcason\Mq\Model\Consumer $consumer
    ) {
        $this->queueMessageRepository = $queueMessageRepository;
        $this->messageEnvelopeFactory = $messageEnvelopeFactory;
        $this->consumer = $consumer;
        parent::__construct($context);
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $entityId = $this->getRequest()->getParam("entity_id");
        
        if(empty($entityId)) {
            $this->messageManager->addError(__('Can\'t find this message.'));
            return $resultRedirect->setPath('*/mq/listing');
        }
        
        $message = $this->queueMessageRepository->get($entityId);
        $queueName = $message->getQueueName();
        
        try {
            $this->consumer->process($queueName, $message);
            $this->messageManager->addSuccess(__("Message {$entityId} executed correctly."));
            return $resultRedirect->setPath('*/mq/listing');        
        } catch (\Exception $ex) {
            $this->messageManager->addError(__("Can't execute {$entityId} message."));
            return $resultRedirect->setPath('*/mq/listing');
        }
        
    }

}
